/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.tags;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;

/**
 * Defines page context attributes useful for scripting.
 */
public class DefineObjectsTag extends org.apache.sling.scripting.jsp.taglib.DefineObjectsTag {

    static final long serialVersionUID = 6250552899680823151L;

    /**
     * Default name for the scripting variable referencing the
     * {@link ComponentContext} object (value is "{@value}").
     */
    public static final String DEFAULT_COMPONENT_CONTEXT_NAME = "componentContext";

    /**
     * Default name for the scripting variable referencing the
     * {@link EditContext} object (value is "{@value}").
     */
    public static final String DEFAULT_EDIT_CONTEXT_NAME = "editContext";

    /**
     * Default name for the scripting variable referencing the
     * {@link ValueMap properties} of the current resource (value is "{@value}").
     */
    public static final String DEFAULT_PROPERTIES_NAME = "properties";

    /**
     * Default name for the scripting variable referencing the
     * {@link PageManager} object (value is "{@value}").
     */
    public static final String DEFAULT_PAGE_MANAGER_NAME = "pageManager";

    /**
     * Default name for the scripting variable referencing the
     * {@link Page current page} object (value is "{@value}").
     */
    public static final String DEFAULT_CURRENT_PAGE_NAME = "currentPage";

    /**
     * Default name for the scripting variable referencing the
     * {@link Page resource page} object (value is "{@value}").
     */
    public static final String DEFAULT_RESOURCE_PAGE_NAME = "resourcePage";

    /**
     * Default name for the scripting variable referencing the
     * {@link InheritanceValueMap page properties} of the current page (value is "{@value}").
     */
    public static final String DEFAULT_PAGE_PROPERTIES_NAME = "pageProperties";

    /**
     * Default name for the scripting variable referencing the
     * {@link Component} of the current resource (value is "{@value}").
     */
    public static final String DEFAULT_COMPONENT_NAME = "component";

    /**
     * Default name for the scripting variable referencing the
     * {@link Designer} object (value is "{@value}").
     */
    public static final String DEFAULT_DESIGNER_NAME = "designer";

    /**
     * Default name for the scripting variable referencing the
     * {@link Design design} of the current page (value is "{@value}").
     */
    public static final String DEFAULT_CURRENT_DESIGN_NAME = "currentDesign";

    /**
     * Default name for the scripting variable referencing the
     * {@link Design design} of the resource page (value is "{@value}").
     */
    public static final String DEFAULT_RESOURCE_DESIGN_NAME = "resourceDesign";

    /**
     * Default name for the scripting variable referencing the
     * {@link Style style} of the current cell (value is "{@value}").
     */
    public static final String DEFAULT_CURRENT_STYLE_NAME = "currentStyle";

	/**
	 * Default name for the scripting variable referencing the
	 * {@link XSSAPI xssAPI protection service} currently in use (value is "{@value}").
	 */
	public static final String DEFAULT_XSSAPI_NAME = "xssAPI";


    /**
     * Default name for the scripting variable referencing the {@link com.day.cq.wcm.api.policies.ContentPolicy} of the current
     * cell (value is "{@value}").
     */
    public static final String DEFAULT_CURRENT_CONTENT_POLICY_NAME = "currentContentPolicy";

    /**
     * Default name for the scripting variable referencing the properties of the current content policy
     * (value is "{@value}").
     */
    public static final String DEFAULT_CURRENT_CONTENT_POLICY_PROPS_NAME = "currentContentPolicyProperties";

    private String componentContextName = DEFAULT_COMPONENT_CONTEXT_NAME;
    private String editContextName = DEFAULT_EDIT_CONTEXT_NAME;
    private String propertiesName = DEFAULT_PROPERTIES_NAME;
    private String pageManagerName = DEFAULT_PAGE_MANAGER_NAME;
    private String currentPageName = DEFAULT_CURRENT_PAGE_NAME;
    private String resourcePageName = DEFAULT_RESOURCE_PAGE_NAME;
    private String pagePropertiesName = DEFAULT_PAGE_PROPERTIES_NAME;
    private String componentName = DEFAULT_COMPONENT_NAME;
    private String designerName = DEFAULT_DESIGNER_NAME;
    private String currentDesignName = DEFAULT_CURRENT_DESIGN_NAME;
    private String resourceDesignName = DEFAULT_RESOURCE_DESIGN_NAME;
    private String currentStyleName = DEFAULT_CURRENT_STYLE_NAME;
	private String xssAPIName = DEFAULT_XSSAPI_NAME;
	private String currentPolicyName = DEFAULT_CURRENT_CONTENT_POLICY_NAME;
	private String currentPolicyPropertiesName = DEFAULT_CURRENT_CONTENT_POLICY_PROPS_NAME;

    /**
     * Creates Scripting variables for:
     * <ul>
     * <li><code>SlingHttpServletRequest</code>
     * <li><code>SlingHttpServletResponse</code>
     * <li>current <code>Resource</code>
     * <li>current <code>Node</code> (if resource is adaptable to a node)
     * <li>current <code>Logger</code>
     * <li>current <code>SlingScriptHelper</code>
     * </ul>
     *
     * @return always {@link #EVAL_PAGE}.
     */
    public int doEndTag() {
        final SlingBindings bindings = (SlingBindings)pageContext.getRequest().getAttribute(SlingBindings.class.getName());

        pageContext.setAttribute(componentContextName, bindings.get(DEFAULT_COMPONENT_CONTEXT_NAME));
        pageContext.setAttribute(editContextName, bindings.get(DEFAULT_EDIT_CONTEXT_NAME));
        pageContext.setAttribute(propertiesName, bindings.get(DEFAULT_PROPERTIES_NAME));
        pageContext.setAttribute(pageManagerName, bindings.get(DEFAULT_PAGE_MANAGER_NAME));
        pageContext.setAttribute(currentPageName, bindings.get(DEFAULT_CURRENT_PAGE_NAME));
        pageContext.setAttribute(resourcePageName, bindings.get(DEFAULT_RESOURCE_PAGE_NAME));
        pageContext.setAttribute(pagePropertiesName, bindings.get(DEFAULT_PAGE_PROPERTIES_NAME));
        pageContext.setAttribute(componentName, bindings.get(DEFAULT_COMPONENT_NAME));
        pageContext.setAttribute(designerName, bindings.get(DEFAULT_DESIGNER_NAME));
        pageContext.setAttribute(currentDesignName, bindings.get(DEFAULT_CURRENT_DESIGN_NAME));
        pageContext.setAttribute(resourceDesignName, bindings.get(DEFAULT_RESOURCE_DESIGN_NAME));
        pageContext.setAttribute(currentStyleName, bindings.get(DEFAULT_CURRENT_STYLE_NAME));
        pageContext.setAttribute(xssAPIName, bindings.get(DEFAULT_XSSAPI_NAME));
        pageContext.setAttribute(currentPolicyName, bindings.get(DEFAULT_CURRENT_CONTENT_POLICY_NAME));
        pageContext.setAttribute(currentPolicyPropertiesName, bindings.get(DEFAULT_CURRENT_CONTENT_POLICY_PROPS_NAME));

            return super.doEndTag();
    }

    public void setComponentContextName(String componentContextName) {
        this.componentContextName = componentContextName;
    }

    public void setEditContextName(String editContextName) {
        this.editContextName = editContextName;
    }

    public void setPropertiesName(String propertiesName) {
        this.propertiesName = propertiesName;
    }

    public void setPageManagerName(String pageManagerName) {
        this.pageManagerName = pageManagerName;
    }

    public void setCurrentPageName(String currentPageName) {
        this.currentPageName = currentPageName;
    }

    public void setResourcePageName(String resourcePageName) {
        this.resourcePageName = resourcePageName;
    }

    public void setResourceDesignName(String resourceDesignName) {
        this.resourceDesignName = resourceDesignName;
    }

    public void setPagePropertiesName(String pagePropertiesName) {
        this.pagePropertiesName = pagePropertiesName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setDesignerName(String designerName) {
        this.designerName = designerName;
    }

    public void setCurrentDesignName(String currentDesignName) {
        this.currentDesignName = currentDesignName;
    }

    public void setCurrentStyleName(String currentStyleName) {
        this.currentStyleName = currentStyleName;
    }

	public void setXssAPIName(String xssAPIName) {
		this.xssAPIName = xssAPIName;
	}

    public void setCurrentPolicyName(String currentPolicyName){
        this.currentPolicyName = currentPolicyName;
    }

    public void setCurrentPolicyPropertiesName(String currentPolicyPropertiesName){
        this.currentPolicyPropertiesName = currentPolicyPropertiesName;
    }
}