/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.tags;

/**
 * <code>RemoveParamTag</code> removes a parameter value from the request URL.
 * If no value is given to the tag, then all parameters with the given name
 * are removed, otherwise only the given value.
 */
public class RemoveParamTag extends AbstractParamTag {

    private static final long serialVersionUID = -205325594674220669L;

    protected void applyTo(RequestURLTag urlTag) {
        String value = getValue();
        if (value == null) {
            urlTag.removeParam(getName());
        } else {
            urlTag.removeParam(getName(), value);
        }
    }
}
