/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.webservicesupport;

import org.apache.sling.api.resource.ResourceResolver;

import aQute.bnd.annotation.ProviderType;

/**
 * The <tt>ConfigurationManagerFactory</tt> provides a way of obtaining a <tt>ConfigurationManager</tt> instance which
 * is backed by a specific <tt>ResourceResolver</tt>
 * 
 * <p>
 * In the context of OSGi services, using this interface is preferred over the <tt>ConfigurationManager</tt> service, as
 * it returns a <tt>ConfigurationManager</tt> instance which uses the caller's session to read repository resources.
 * </p>
 *
 */
@ProviderType
public interface ConfigurationManagerFactory {

    /**
     * Returns a <tt>ConfigurationManager</tt> instance backed by the specified <tt>ResourceResolver</tt>
     * 
     * @param resolver the resource resolver, must not be <tt>null</tt>
     * @return a <tt>ConfigurationManager</tt> instance, never <code>null</code>
     */
    ConfigurationManager getConfigurationManager(ResourceResolver resolver);

}
