/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.workflow.api;

import com.day.cq.workflow.exec.Workflow;

/**
 * The <code>WcmWorkflowStatus</code> holds all information for a page which
 * is in the workflow or even not
 */
public interface WcmWorkflowStatus {
    /**
     * Indicates if a page is subject of a workflow
     *
     * @return <code>true</code> if subject of a workflow otherwise
     * <code>false</code>
     */
    boolean isInRunningWorkflow();

    /**
     * Returns the <code>{@link Workflow} instance</code>
     *
     * @return <code>{@link Workflow} instance</code>
     */
    Workflow getWorkflow();
}
