/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2014 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.cq.wcm.workflow.process;

import com.day.cq.replication.*;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

import com.day.cq.workflow.exec.WorkflowProcess;

import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;

import javax.jcr.Session;

/**
 * <code>AfterMovePageProcess</code>
 * Process to perform replication after a move operation.
 *
 * @see ReplicatePageProcess
 */
@Component
@Service(WorkflowProcess.class)
@Property(name = "process.label", value = "Replicate After Page Move")
public class AfterMovePageProcess implements WorkflowProcess {

    @Reference
    protected ResourceResolverFactory resourceResolverFactory;

    @Reference
    protected Replicator replicator;

    private static final Logger log = LoggerFactory.getLogger(AfterMovePageProcess.class);

    public AfterMovePageProcess() {
    }

    /**
     * @see com.day.cq.workflow.exec.WorkflowProcess#execute(com.day.cq.workflow.exec.WorkItem,
     *      com.day.cq.workflow.WorkflowSession,
     *      com.day.cq.workflow.metadata.MetaDataMap)
     */
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        try {
            MetaDataMap metaDataMap = workItem.getWorkflowData().getMetaDataMap();
            // metadata
            String srcPath = metaDataMap.get("srcPath", String.class);
            ReplicationActionType replicationType = ReplicationActionType.valueOf(metaDataMap.get("replicationType", String.class));
            String[] publishReferences = metaDataMap.get("publishReferences", String[].class);

            // @todo check all permissions

            //
            Session session = workflowSession.getSession();
            ResourceResolver resourceResolver = resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session",(Object)session));
            // republish page
            log.debug("Replicate page in workflow " + srcPath);
            replicator.replicate(session, replicationType, srcPath);

            // republish references
            if (publishReferences != null) {
                for (String ref: publishReferences) {
                    log.debug("Replicate reference of page (" + srcPath + ") in workflow " + ref);
                    replicator.replicate(session, ReplicationActionType.ACTIVATE, ref);
                }
            }

		} catch (ReplicationException e) {
			throw new WorkflowException(e);
		} catch (LoginException e) {
			throw new WorkflowException(e);
		}
    }
}