/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2014 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.cq.wcm.workflow.process;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.felix.scr.annotations.*;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

@Component
@Service({ WorkflowProcess.class })
@Properties({
        @Property(name="process.label", value="Delete Page")
})
public class DeletePageProcess implements WorkflowProcess {

    @Reference
    protected ResourceResolverFactory resourceResolverFactory;

    private static final Logger log = LoggerFactory.getLogger(DeletePageProcess.class);

    private static final String TYPE_JCR_PATH = "JCR_PATH";

    public DeletePageProcess() {
    }

    /**
     * @see com.day.cq.workflow.exec.WorkflowProcess#execute(com.day.cq.workflow.exec.WorkItem,
     *      com.day.cq.workflow.WorkflowSession,
     *      com.day.cq.workflow.metadata.MetaDataMap)
     */
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        try {
            Session session = workflowSession.getSession();
			ResourceResolver resolver = resourceResolverFactory
					.getResourceResolver(Collections.singletonMap("user.jcr.session", (Object) session));

            // data
            WorkflowData data = workItem.getWorkflowData();
            String path = null;
            String type = data.getPayloadType();
            if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null) {
                String payloadData = (String) data.getPayload();
                if (session.itemExists(payloadData)) {
                    path = payloadData;
                }
            }

            if (path == null) {
                throw new WorkflowException("No path was given for the workflow");
            }

            // resource
            Resource resource = resolver.getResource(path);

            // delete
            Node node = resource.adaptTo(Node.class);
            if (session.nodeExists(node.getPath())) {
                node.remove();
            }
            session.save();
        } catch (RepositoryException e) {
            throw new WorkflowException(e);
        } catch (LoginException e) {
        	throw new WorkflowException(e);
		} finally {

        }
    }
}
