/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.collection;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.osgi.annotation.versioning.ProviderType;
import java.util.List;

/**
 * The <code>ResourceCollection</code> represents a collection of jcr resources (nodes)
 * which can be added/removed.
 * The collection is also able to listen to (jcr) modifications undertaken by
 * a certain user. this modifications respectively the modified resource is added
 * to the list as well.
 */
@ProviderType
public interface ResourceCollection {

    /**
     * Name of the node containing filter definitions' items
     */
    public static final String NN_FILTER = "filter";

    /**
     * Property name of a filter's item root path
     */
    public static final String PN_FILTER_ROOT = "root";

    /**
     * All collection members are retourned
     *
     * @param allowedNodesTypes list of node types to be considered
     *
     * @return a list of all members
     *
     * @throws javax.jcr.RepositoryException in case an error occurs while
     *         fetching the list.
     */
    List<Node> list(String[] allowedNodesTypes) throws RepositoryException;

    /**
     * Add member to the collection
     *
     * @param node to add
     */
    void add(Node node);

    /**
     * Remove member
     *
     * @param node node to remove
     */
    void remove(Node node);

    /**
     * Starts the recording.
     *
     * @param userId user id
     * @param rootPath root path to nodes
     * @param nodeTypes nodes to be removed
     */
    void startRecording(String userId, String rootPath, String nodeTypes[]);

    /**
     * Stops the recording.
     *
     * @param userId user id
     */
    void stopRecording(String userId);

    /**
     * Returns collection path
     * @return collection path
     */
    String getPath();
    /**
     * @param path path to be find
     * @return true if member exist, false otherwise
     */
    boolean hasNode(String path);
}
