/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.workflow.compatibility;

import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.DynamicParticipantExecutor;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.exec.ParticipantChooser;
import com.day.cq.workflow.exec.ParticipantStepChooser;
import com.day.cq.workflow.impl.CQWorkflowSessionWrapper;
import com.day.cq.workflow.impl.exec.CQWorkItemWrapper;
import com.day.cq.workflow.impl.metadata.CQMetaDataMap;
import com.day.cq.workflow.impl.model.CQWorkflowNodeWrapper;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Component(metatype = false, label = "%cq.workflow.compat.executor.dynamicparticipant.name", description = "%cq.workflow.compat.executor.dynamicparticipant.description")
@Property(name = "service.description", value="%cq.workflow.compat.executor.dynamicparticipant.description")
@References({
        @Reference(name = "ParticipantChooser", cardinality = ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface = ParticipantChooser.class, policy = ReferencePolicy.DYNAMIC),
        @Reference(name = "ParticipantStepChooser", cardinality = ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface = ParticipantStepChooser.class, policy = ReferencePolicy.DYNAMIC)
})
@Service
public class CQDynamicParticipantExecutor implements DynamicParticipantExecutor {
    protected final Logger log = LoggerFactory.getLogger(getClass());

    @Reference
    private WorkflowService cqWorkflowService;

    protected List<ParticipantChooser> participantChooser = new CopyOnWriteArrayList<ParticipantChooser>();
    protected List<ParticipantStepChooser> participantStepChooser = new CopyOnWriteArrayList<ParticipantStepChooser>();

    public void bindParticipantChooser(ParticipantChooser aParticipantChooser) {
        this.participantChooser.add(aParticipantChooser);
    }

    public void unbindParticipantChooser(ParticipantChooser aParticipantChooser) {
        this.participantChooser.remove(aParticipantChooser);
    }

    public void bindParticipantStepChooser(ParticipantStepChooser aParticipantStepChooser) {
        this.participantStepChooser.add(aParticipantStepChooser);
    }

    public void unbindParticipantStepChooser(ParticipantStepChooser aParticipantStepChooser) {
        this.participantStepChooser.remove(aParticipantStepChooser);
    }

    public boolean canExecute(String aResourceName) {
        return evaluateExecutable(aResourceName)!=null;
    }

    public String getParticipant(String aResourceName, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) {
        Object toBeExecuted = evaluateExecutable(aResourceName);
        try {
            if (toBeExecuted!=null) {
                CQWorkflowSessionWrapper sessionWrapper = new CQWorkflowSessionWrapper(cqWorkflowService, workflowSession);
                CQWorkItemWrapper workItemWrapper = new CQWorkItemWrapper(workItem);
                CQMetaDataMap cqMetaDataMap = new CQMetaDataMap(metaDataMap);
                String args[] = getArgs(workItem);

                if (toBeExecuted instanceof ParticipantStepChooser) {
                    ParticipantStepChooser chooser = (ParticipantStepChooser) toBeExecuted;
                    return chooser.getParticipant(workItemWrapper, sessionWrapper, cqMetaDataMap);
                }
                // TODO remove after 5.4
                else if (toBeExecuted instanceof ParticipantChooser) {
                    ParticipantChooser chooser = (ParticipantChooser) toBeExecuted;
                    return chooser.getParticipant(workItemWrapper, sessionWrapper, args);

                }
            }
        } catch (Exception e) {
            log.error("ParticipantChooser execution resulted in an error: " + e.getMessage(), e);
        }
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    /**
     * Attempts to evaluate the participant chooser implementation for the given
     * resource.
     *
     * @param resource The name of the participant chooser to search for.
     * @return The participant chooser implementation to use, or
     *         <code>null</code> if none can be evaluated.
     */
    private Object evaluateExecutable(String resource) {
        Object toBeExecuted = null;
        for (ParticipantStepChooser chooser : participantStepChooser) {
            if (resource.equals(chooser.getClass().getName())) {
                toBeExecuted = chooser;
                break;
            }
        }

        // TODO remove after 5.4
        if (toBeExecuted == null) {
            for (ParticipantChooser chooser : participantChooser) {
                if (resource.equals(chooser.getClass().getName())) {
                    toBeExecuted = chooser;
                    break;
                }
            }
        }

        return toBeExecuted;
    }

    protected String[] getArgs(WorkItem item) {
        String arguments = item.getNode().getMetaDataMap().get(CQWorkflowNodeWrapper.PROCESS_ARGS, String.class);
        if (arguments != null && !arguments.equals("")) {
            return arguments.split(",");
        }
        return new String[0];
    }
}
