/*
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.day.cq.workflow.compatibility;

import com.day.cq.workflow.event.WorkflowEvent;
import com.day.cq.workflow.impl.exec.CQWorkItemWrapper;
import com.day.cq.workflow.impl.exec.CQWorkflowDataWrapper;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;

import org.apache.sling.event.dea.DEAConstants;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventConstants;
import org.osgi.service.event.EventHandler;

import java.util.Dictionary;
import java.util.Hashtable;


@Component (immediate = true)
@Service
@Property(name = EventConstants.EVENT_TOPIC, value = {com.adobe.granite.workflow.event.WorkflowEvent.EVENT_TOPIC})
public class CQEventDispatcher implements EventHandler {

    @Reference(policy = ReferencePolicy.STATIC)
    private EventAdmin eventAdmin;

    public void handleEvent(Event event) {
        // need to re-dispatch CQ events for backwards compatibility
        com.adobe.granite.workflow.event.WorkflowEvent graniteWorkflowEvent = (com.adobe.granite.workflow.event.WorkflowEvent)event;

        final Dictionary<String, Object> properties = new Hashtable<String, Object>();

        addProperty(properties, WorkflowEvent.DELEGATEE, graniteWorkflowEvent.getDelegateName());
        addProperty(properties, WorkflowEvent.EVENT_TYPE, graniteWorkflowEvent.getEventType());
        addProperty(properties, WorkflowEvent.FROM_NODE_NAME, graniteWorkflowEvent.getFromNodeName());
        addProperty(properties, WorkflowEvent.VARIABLE_NAME, graniteWorkflowEvent.getVariableName());
        addProperty(properties, WorkflowEvent.VARIABLE_VALUE, graniteWorkflowEvent.getVariableValue());
        addProperty(properties, WorkflowEvent.PARENT_WORKFLOW_ID, graniteWorkflowEvent.getParentWorkflowId());
        addProperty(properties, WorkflowEvent.TIME_STAMP, graniteWorkflowEvent.getTimeStamp());
        addProperty(properties, WorkflowEvent.TO_NODE_NAME, graniteWorkflowEvent.getToNodeName());
        addProperty(properties, WorkflowEvent.USER, graniteWorkflowEvent.getUser());
        addProperty(properties, WorkflowEvent.WORKFLOW_NAME, graniteWorkflowEvent.getWorkflowName());
        addProperty(properties, WorkflowEvent.WORKFLOW_NODE, graniteWorkflowEvent.getWorkflowNode());
        addProperty(properties, WorkflowEvent.WORKFLOW_VERSION, graniteWorkflowEvent.getWorkflowVersion());
        addProperty(properties, WorkflowEvent.WORKFLOW_INSTANCE_ID, graniteWorkflowEvent.getWorkflowInstanceId());

        addProperty(properties, "oldPayloadPath", graniteWorkflowEvent.getProperty("oldPayloadPath"));
        addProperty(properties, "payloadPath", graniteWorkflowEvent.getProperty("payloadPath"));

        if (graniteWorkflowEvent.getWorkflowData() != null && graniteWorkflowEvent.getWorkflowData() != null) {
            addProperty(properties, WorkflowEvent.WORK_DATA, new CQWorkflowDataWrapper(graniteWorkflowEvent.getWorkflowData()));
        }

        if (graniteWorkflowEvent.getWorkItem() != null && graniteWorkflowEvent.getWorkItem()!=null) {
            addProperty(properties, WorkflowEvent.WORK_ITEM, new CQWorkItemWrapper(graniteWorkflowEvent.getWorkItem()));
        }

        addProperty(properties, DEAConstants.PROPERTY_APPLICATION , graniteWorkflowEvent.getProperty(DEAConstants.PROPERTY_APPLICATION ));
        WorkflowEvent cqWorkflowEvent = new WorkflowEvent(properties);

        eventAdmin.sendEvent(cqWorkflowEvent);
    }

    private void addProperty(Dictionary<String, Object> dictionary, String key, Object value) {
        if (key != null && value != null) {
            dictionary.put(key, value);
        }
    }
}
