/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.workflow.compatibility;

import com.adobe.granite.workflow.exec.ScriptContextProvider;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.impl.CQWorkflowSessionWrapper;
import com.day.cq.workflow.impl.exec.CQWorkItemWrapper;
import com.day.cq.workflow.impl.exec.CQWorkflowDataWrapper;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Adds backwards compatible script context for workflow script execution.
 * The script context is updated with
 */
@Component(metatype = false, label = "%cq.workflow.compat.scriptcontext.name", description = "%cq.workflow.compat.scriptcontext.description")
@Service(value = ScriptContextProvider.class)
public class ScriptContextProviderImpl implements ScriptContextProvider {

    private static final String GRANITE_WORKITEM_SCRIPT_ENTRY = "graniteWorkItem";
    private static final String GRANITE_WORKFLOW_SESSION_SCRIPT_PROPERTY = "graniteWorkflowSession";
    private static final String GRANITE_WORKFLOW_DATA = "graniteWorkflowData";

    private static final String WORKITEM_SCRIPT_ENTRY = "workItem";
    private static final String WORKFLOW_SESSION_SCRIPT_PROPERTY = "workflowSession";
    private static final String WORKFLOW_DATA = "workflowData";

    @Reference
    private WorkflowService cqWorkflowService;

    protected final Logger log = LoggerFactory.getLogger(getClass());

    /**
     * wraps known script context objects with backwards compatible CQ ones
     * @param map map of values being provided by granite workflow engine
     */
    public void addContext(Map map) {

        addCQWrappedObject(map, GRANITE_WORKITEM_SCRIPT_ENTRY, WORKITEM_SCRIPT_ENTRY, com.adobe.granite.workflow.exec.WorkItem.class, CQWorkItemWrapper.class);
        addCQWrappedObject(map, GRANITE_WORKFLOW_DATA, WORKFLOW_DATA, com.adobe.granite.workflow.exec.WorkflowData.class, CQWorkflowDataWrapper.class);

        addCQWrappedObjectWithWorkflowService(map, GRANITE_WORKFLOW_SESSION_SCRIPT_PROPERTY, WORKFLOW_SESSION_SCRIPT_PROPERTY, com.adobe.granite.workflow.WorkflowSession.class, CQWorkflowSessionWrapper.class);

    }

    private void addCQWrappedObject(Map map, String graniteName, String cqName, Class graniteClass, Class cqClass) {
        try{
            if (map.get(graniteName) != null && graniteClass.isInstance(map.get(graniteName))) {
                map.put(cqName, cqClass.getConstructor(graniteClass).newInstance(map.get(graniteName)));
            }
        } catch (Exception e) {
            log.error("error setting up CQ Script Context", e);
        }
    }

    private void addCQWrappedObjectWithWorkflowService(Map map, String graniteName, String cqName, Class graniteClass, Class cqClass) {
        try{
            if (map.get(graniteName) != null && graniteClass.isInstance(map.get(graniteName))) {
                map.put(cqName, cqClass.getConstructor(WorkflowService.class, graniteClass).newInstance(cqWorkflowService, map.get(graniteName)));
            }
        } catch (Exception e) {
            log.error("error setting up CQ Script Context", e);
        }
    }
}
