/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.exec;

import java.util.Date;

/**
 * <code>HistoryItem</code>...
 */
public interface HistoryItem {
    /**
     * The history comment (entered while advancing, starting, terminating)
     *
     * @return comment
     */
    String getComment();

    /**
     * The action that got issued on the <code>{@link com.day.cq.workflow.exec.WorkItem}</code>
     *
     * @return action descriptor as string
     */
    String getAction();

    /**
     * Date when an action <code>{@link com.day.cq.workflow.exec.WorkItem}</code>
     * got issued that caused this <code>HistoryItem</code>
     *
     * @return date
     */
    Date getDate();

    /**
     * User who triggered the  action <code>{@link com.day.cq.workflow.exec.WorkItem}</code>
     * hat caused this <code>HistoryItem</code>
     *
     * @return the user id
     */
    String getUserId();

    /**
     * Returns the previous history item.
     *
     * @return the previous {@link HistoryItem}
     * if available otherwise <code>null</code>
     */
    HistoryItem getPreviousHistoryItem();

    /**
     * Returns the next history item.
     *
     * @return the next {@link HistoryItem}
     * if available otherwise <code>null</code>
     */
    HistoryItem getNextHistryItem();

    /**
     * Returns the corresponding {@link WorkItem}
     *
     * @return {@link WorkItem}
     */
    WorkItem getWorkItem();
}
