/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.exec;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.model.WorkflowNode;

/**
 * <code>JavaProcessNew</code> is the interface to be used for automatic
 * workflow steps implemented in Java. Classes implementing this interface
 * define Java based processes that can be attached to a {@link WorkflowNode}
 * and executed by the workflow engine.
 * <p>
 * This interface replaces the deprecated {@link JavaProcess} and
 * {@link JavaProcessExt} interfaces.
 * 
 * @see JavaProcess
 * @see JavaProcessExt
 * @since 5.4
 */
public interface WorkflowProcess {
    /**
     * Executes a new Java process with the given <code>{@link WorkItem}</code>
     * and <code>{@link com.day.cq.workflow.WorkflowSession}</code>.
     * 
     * @param item
     *            The <code>{@link WorkItem}</code> that defines the newly
     *            started <code>JavaProcessNew</code>.
     * @param session
     *            The <code>{@link com.day.cq.workflow.WorkflowSession}</code>
     *            that is used for starting the <code>JavaProcess</code>.
     * @param args
     *            Process specific arguments can be passed here
     * @throws WorkflowException
     *             Thrown in case something goes wrong during execution.
     */
    void execute(WorkItem item, WorkflowSession session, MetaDataMap args) throws WorkflowException;
}
