/*
 * Copyright 2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.metadata;

import java.util.Map;

/**
 * A value map for generic access to meta data values.
 * 
 * @since 5.4
 */
public interface MetaDataMap extends Map<String, Object> {

    /**
     * Get a meta data property and make an attempt to convert it into the given
     * type.
     * 
     * @param name
     *            The name of the meta data property
     * @param type
     *            The class of the type to use for conversion.
     * @return The value of the property converted to type T or
     *         <code>null</code> if there is no such property or it cannot be
     *         converted to the given type.
     */
    <T> T get(String name, Class<T> type);

    /**
     * Get a meta data property and make an attempt to convert it into the given
     * type.
     * 
     * @param name
     *            The name of the meta data property
     * @param defaultValue
     *            A default value to use in case the property does not exist or
     *            cannot be converted. The type to convert to is determined by
     *            the type of the default value. If the default value is
     *            <code>null</code> and a property for the given name exists, it
     *            is returned without conversion.
     * @return The value of the property converted to type T or
     *         <code>null</code> if there is no such property or it cannot be
     *         converted to the given type.
     */
    <T> T get(String name, T defaultValue);

}
