/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.model;

import com.day.cq.workflow.HasMetaData;

import java.util.List;

/**
 * <code>WorkflowNode</code> represents a node/step in a
 * <code>{@link WorkflowModel}</code>.
 */
public interface WorkflowNode extends HasMetaData {
    public static final String TYPE_START = "START";
    public static final String TYPE_END = "END";
    public static final String TYPE_AND_SPLIT = "AND_SPLIT";
    public static final String TYPE_AND_JOIN = "AND_JOIN";
    public static final String TYPE_OR_SPLIT = "OR_SPLIT";
    public static final String TYPE_OR_JOIN = "OR_JOIN";
    public static final String TYPE_PROCESS = "PROCESS";
    public static final String TYPE_CONTAINER = "CONTAINER";
    public static final String TYPE_PARTICIPANT = "PARTICIPANT";
    public static final String TYPE_DYNAMIC_PARTICIPANT = "DYNAMIC_PARTICIPANT";
    public static final String TYPE_EXTERNAL_PROCESS = "EXTERNAL_PROCESS";
    
	/**
	 * Returns the ID of the <code>WorkflowNode</code>.
	 * 
	 * @return ID of the <code>WorkflowNode</code>.
	 */
	String getId();

	/**
	 * Returns the type of the <code>WorkflowNode</code>. Must be unique
	 * across all available types of <code>WorkflowNode</code>s.
	 * 
	 * @return The type of the <code>WorkflowNode</code>.
	 */
	String getType();

	/**
	 * Sets the type of the <code>WorkflowNode</code>. Must be unique across
	 * all available types of <code>WorkflowNode</code>s.
	 * 
	 * @param type
	 *            The new type the the <code>WorkflowNode</code>.
	 */
	void setType(String type);

	/**
	 * Returns the description of the <code>WorkflowNode</code>.
	 * 
	 * @return The description of the <code>WorkflowNode</code>.
	 */
	String getDescription();

	/**
	 * Set the description of the <code>WorkflowNode</code>.
	 * 
	 * @param description
	 *            The new description of the <code>WorkflowNode</code>.
	 */
	void setDescription(String description);

	/**
	 * Returns the outgoing <code>{@link WorkflowTransition}</code>s assigned
	 * to the <code>WorkflowNode</code>.
	 * 
	 * @return <code>{@link WorkflowTransition}</code>s associated with the
	 *         <code>WorkflowNode</code> (only outgoing).
	 */
	List<WorkflowTransition> getTransitions();
	
	/**
     * Returns the incoming <code>{@link WorkflowTransition}</code>s assigned
     * to the <code>WorkflowNode</code>.
     * 
     * @return <code>{@link WorkflowTransition}</code>s associated with the
     *         <code>WorkflowNode</code> (only incoming).
     */
    List<WorkflowTransition> getIncomingTransitions();

	/**
	 * Returns the <code>WorkflowNode</code>s title.
	 * 
	 * @return The title of the <code>WorkflowNode</code>.
	 */
	String getTitle();

	/**
	 * Sets the title of the <code>WorkflowNode</code>.
	 * 
	 * @param title
	 *            The new title of the <code>WorkflowNode</code>.
	 */
	void setTitle(String title);
}
