package com.day.cq.workflow.status;

import com.day.cq.workflow.exec.Workflow;

import java.util.List;

/**
 * The <code>WorkflowStatus</code> holds all information for a node which
 * is in the workflow or even not
 */
public interface WorkflowStatus {
    /**
     * Indicates if a page is subject of a workflow and excludes always
     * system workflows.
     *
     * @return <code>true</code> if subject of a workflow otherwise
     * <code>false</code>
     *
     * @deprecated use {@link com.day.cq.workflow.status.WorkflowStatus#isInRunningWorkflow(boolean)} instead
     */
    boolean isInRunningWorkflow();

    /**
     * Indicates if a page is subject of a workflow
     *
     * @param excludeSystemWorkflows set to <code>true</code> to exclude system
     *        workflows from the evaluation
     *
     * @return <code>true</code> if subject of a workflow otherwise
     * <code>false</code>
     */
    boolean isInRunningWorkflow(boolean excludeSystemWorkflows);

    /**
     * Returns the <code>{@link com.day.cq.workflow.exec.Workflow} instance</code>
     *
     * @return <code>{@link com.day.cq.workflow.exec.Workflow} instance</code>
     *
     * @deprecated  use {@link com.day.cq.workflow.status.WorkflowStatus#getWorkflows(boolean)} instead
     */
    Workflow getWorkflow();

    /**
     * Returns the <code>{@link com.day.cq.workflow.exec.Workflow} instances</code>
     *
     * @param excludeSystemWorkflows set to <code>true</code> to exclude system
     *        workflows from the evaluation
     *
     * @return <code>{@link com.day.cq.workflow.exec.Workflow} instances</code>
     */
    List<Workflow> getWorkflows(boolean excludeSystemWorkflows);
}
