/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.ui;

import com.day.cq.workflow.exec.WorkItem;

/**
 * The <code>JcrPathBuilderManager</code> does "provide" different jcr path
 * builders that build the <code>payload path</code> depending on the payload
 * and its workflow state. You can control the lookup sequence of  the
 * {@link JcrPayloadPathBuilder}s by specifying the <code>service.ranking</code>
 * of each {@link JcrPayloadPathBuilder}. The builder with the lowest ranking is
 * called first. if no ranking is defined the ranking is considered as 0.
 */
public interface JcrPathBuilderManager {

    /**
     * Builds the path depending on <code>payload</code> and workflow/item state
     *
     * @param workItem work item
     * @return a string containing the built path or <code>null</code> in case
     * the builder was not able or not responsible to build the path.
     */
    String getPath(WorkItem workItem);
}
