/*##############################################################################
 # ADOBE CONFIDENTIAL
 # ___________________
 #
 #  Copyright 2020 Adobe
 #  All Rights Reserved.
 #
 # NOTICE: All information contained herein is, and remains
 # the property of Adobe and its suppliers, if any. The intellectual
 # and technical concepts contained herein are proprietary to Adobe
 # and its suppliers and are protected by all applicable intellectual
 # property laws, including trade secret and copyright laws.
 # Dissemination of this information or reproduction of this material
 # is strictly forbidden unless prior written permission is obtained
 # from Adobe.
 #############################################################################*/
package com.day.cq.xss;

/**
 * This enumeration defines the context for executing XSS protection.
 * <p>
 * The specified rules refer to
 * http://www.owasp.org/index.php/XSS_%28Cross_Site_Scripting%29_Prevention_Cheat_Sheet
 *
 * @since 5.4
 * @deprecated
 */
public enum ProtectionContext {

    /*
     * Escape plain text for use inside a HTML attribute (rule #2)
     */
    // PLAIN_HTML_ATTRIBUTE("plainToHtmlAttribute"),

    /*
     * Escape plain text for use inside a JavaScript String (rule #3)
     */
    // PLAIN_JS_STRING("plainToJSString"),

    /**
     * Escape HTML for use inside element content (rules #6 and - to some degree - #1),
     * using a policy to remove potentially malicous HTML
     */
    HTML_HTML_CONTENT("htmlToHtmlContent"),

    /**
     * Escape plain text for use inside HTML content (rule #1)
     */
    PLAIN_HTML_CONTENT("plainToHtmlContent");

    /**
     * The name of the protection context (used by the taglib)
     */
    private String name;

    private ProtectionContext(String name) {
        this.name = name;
    }

    /**
     * Gets the name of the protection context.
     *
     * @return The name of the protection context
     */
    public String getName() {
        return this.name;
    }

    /**
     * Gets a protection context from the specified name.
     *
     * @param name The name to get the protection context from
     * @return The protection context; <code>null</code> if an invalid protection context
     *         has been specified
     */
    public static ProtectionContext fromName(String name) {
        ProtectionContext[] values = values();
        for (ProtectionContext contextToCheck : values) {
            if (contextToCheck.getName().equals(name)) {
                return contextToCheck;
            }
        }
        return null;
    }

}
