/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics;

/**
 * <code>JanitorReport</code> is a base class for reports that clean up
 * historical data, which is not needed anymore.
 *
 * @author mreutegg
 */
public abstract class JanitorReport extends Report {

    /**
     * Milliseconds in a year.
     */
    private static final long ONE_YEAR = 1000L * 60L * 60L * 24L * 365L;

    /**
     * Per default keep day statistics for one year.
     */
    private long dayThresholdDate = System.currentTimeMillis() - ONE_YEAR;

    /**
     * Per default keep month statistics for three years.
     */
    private long monthThresholdDate = System.currentTimeMillis() - ONE_YEAR * 3;

    /**
     * Whether the data should actually be removed.
     */
    private final boolean dryRun;

    public JanitorReport(String dataPath, boolean dryRun) {
        super(dataPath);
        this.dryRun = dryRun;
    }

    //--------------------------< properties >----------------------------------

    public long getDayThresholdDate() {
        return dayThresholdDate;
    }

    public void setDayThresholdDate(long dayThresholdDate) {
        this.dayThresholdDate = dayThresholdDate;
    }

    public long getMonthThresholdDate() {
        return monthThresholdDate;
    }

    public void setMonthThresholdDate(long monthThresholdDate) {
        this.monthThresholdDate = monthThresholdDate;
    }

    public boolean isDryRun() {
        return dryRun;
    }
}
