/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics.query;

import com.day.crx.statistics.Entry;
import com.day.crx.statistics.PathBuilder;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.jackrabbit.util.Text;

/**
 * <code>Query</code> provides information about a query execution.
 *
 * @author mreutegg
 */
public class Query extends Entry {

    /**
     * The query string as entered by the user.
     */
    private final String query;

    /**
     * The total number of results the query returned.
     */
    private final long numResults;

    /**
     * The execution time of the query.
     */
    private final long executionTime;

    /**
     * Creates a new query instance.
     *
     * @param pathPrefix    the location where the query information will be
     *                      stored.
     * @param query         the query string as entered by the user.
     * @param numResults    the total number of results.
     * @param executionTime the execution time of the query.
     */
    public Query(String pathPrefix, String query, long numResults, long executionTime) {
        super(pathPrefix);
        this.query = query;
        this.numResults = numResults;
        this.executionTime = executionTime;
    }


    /**
     * Writes the statistics to the passed node.
     *
     * @param node the node where to write the statistics.
     * @throws RepositoryException if an error occurs while writing.
     */
    public void write(Node node) throws RepositoryException {
        long count = 1;
        if (node.hasProperty("count")) {
            count = node.getProperty("count").getLong() + 1;
        }
        node.setProperty("count", count);
        node.setProperty("numResults", numResults);
        node.setProperty("executionTime", executionTime);
    }

    /**
     * {@inheritDoc}
     */
    protected PathBuilder getPathBuilder() {
        return new QueryPathBuilder();
    }

    /**
     * @return the user supplied query string.
     */
    String getQuery() {
        return query;
    }
}
