/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics.query;

import com.day.crx.statistics.PathBuilder;
import com.day.crx.statistics.Entry;
import org.apache.jackrabbit.util.Text;

/**
 * <code>QueryPathBuilder</code> implements a path builder for {@link Query}
 * instances.
 *
 * @author mreutegg
 */
class QueryPathBuilder extends PathBuilder {

    /**
     * Default constructor.
     */
    public QueryPathBuilder() {
        super("yyyy/MM/dd");
    }

    /**
     * Formats the path for a {@link Query} instance.
     *
     * @param entry  a {@link Query} instance.
     * @param buffer where to write the path to.
     */
    public void formatPath(Entry entry, StringBuffer buffer) {
        Query query = (Query) entry;
        buffer.append(entry.getPathPrefix());
        buffer.append("/");
        // add date nodes as specified in constructor pattern
        super.formatPath(entry, buffer);
        buffer.append("/");
        buffer.append(Text.escapeIllegalJcrChars(query.getQuery()));
    }
}
