/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics.result;

import com.day.crx.statistics.Report;

import javax.jcr.Session;
import javax.jcr.RepositoryException;
import javax.jcr.Node;
import javax.jcr.Item;
import javax.jcr.Value;
import java.util.Iterator;
import java.util.Calendar;
import java.util.ArrayList;
import java.util.List;

import org.apache.jackrabbit.util.Text;

/**
 * <code>QueriesByResultReport</code> implements a report that returns queries
 * for a given result path. The queries are grouped by the twelve most recent
 * calendar months.
 *
 * @author mreutegg
 */
public class QueriesByResultReport extends Report {

    /**
     * Path of the result page.
     */
    private final String path;

    /**
     * Creates a new report.
     *
     * @param dataPath the path prefix to the data.
     * @param path     the path of the result page.
     */
    public QueriesByResultReport(String dataPath, String path) {
        super(dataPath);
        this.path = path;
    }

    /**
     * {@inheritDoc}
     * <p/>
     * Returns result rows with the following objects:
     * <ul>
     * <li><code>Long</code> timestamp, which indicates the month</li>
     * <li><code>String[]</code> with recent queries in that month, which lead
     * to the result page.</li>
     * </ul>
     */
    public Iterator getResult(Session session) throws RepositoryException {
        List data = new ArrayList();
        ResultSelected dummy = new ResultSelected(getDataPath(), path, 0, "");
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_MONTH, 1);
        for (int i = 0; i < 12; i++) {
            dummy.setTimestamp(cal.getTimeInMillis());
            String p = Text.getRelativeParent(dummy.getPath(), 1);
            List queries = new ArrayList();
            if (session.itemExists(p)) {
                Item item = session.getItem(p);
                if (item instanceof Node) {
                    Node n = (Node) item;
                    if (n.hasProperty(ResultSelected.QUERIES)) {
                        Value[] values = n.getProperty(ResultSelected.QUERIES).getValues();
                        for (int j = 0; j < values.length; j++) {
                            queries.add(values[j].getString());
                        }
                    }
                }
            }
            data.add(new Object[]{new Long(cal.getTimeInMillis()),
                                  queries.toArray(new String[queries.size()])});
            cal.add(Calendar.MONTH, -1);
        }
        return data.iterator();
    }
}
