/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics.result;

import com.day.crx.statistics.PathBuilder;
import com.day.crx.statistics.Entry;

/**
 * <code>ResultSelectedPathBuilder</code> implements a path builder for
 * {@link ResultSelected} instances.
 *
 * @author mreutegg
 */
public class ResultSelectedPathBuilder extends PathBuilder {

    /**
     * The name of the node that contains the statistical data about a result
     * page.
     */
    public static final String STATS_NAME = ".stats";

    /**
     * Default constructor.
     */
    public ResultSelectedPathBuilder() {
        super("yyyy/MM/dd");
    }

    /**
     * Formats the path for a {@link ResultSelected} instance.
     *
     * @param entry  a {@link ResultSelected} instance.
     * @param buffer where to write the path to.
     */
    public void formatPath(Entry entry, StringBuffer buffer) {
        ResultSelected rs = (ResultSelected) entry;
        buffer.append(rs.getPathPrefix());
        buffer.append(rs.getResultPath());
        buffer.append("/").append(STATS_NAME).append("/");
        // add date nodes as specified in constructor pattern
        super.formatPath(rs, buffer);
    }
}
