/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.image;

import java.awt.Color;
import java.awt.image.BufferedImage;

/**
 * The <code>Dither</code> provides the dithering capability for reducing colors
 * of an image to 2, 4, 8, 16, 32, 64, 128 or 256 colors. The real number of
 * colors at the end of color reduction depends on the color profile of the
 * image under reduction.
 * <p>
 * Currently the following two dithering algorithm's are supported :
 * <li>
 * <ol>Simple reduction by reducing the bit width of the color components
 * <ol>Reduction by reducing the bit width and doing some rudimentary error
 *     correction on neighbouring pixels.
 * </li>
 *
 * @version $Revision$, $Date$
 * @author fmeschbe, based on CQ2's rgba2/rgbacolor.c color reduction
 *
 * @deprecated as of Communiqu� 3.1.0, use com.day.image.DitherOp instead, this
 * 		class will be removed in the next release.
 */
@Deprecated
public class Dither {

    /**
     * Indicate the use of the simple bit width color reduction algorithm
     * with no further dithering effects.
     *
     * @deprecated as of Communiqu� 3.1.0, use com.day.image.DitherOp instead,
     * 		this class will be removed in the next release.
     */
    @Deprecated
    public static final int DITHER_NONE                     = 0x01;

    /**
     * Indicate the use of the simple bit width color reduction algorithm
     * plus using the simple error correction algorithm.
     *
     * @deprecated as of Communiqu� 3.1.0, use com.day.image.DitherOp instead,
     * 		this class will be removed in the next release.
     */
    @Deprecated
    public static final int DITHER_SIMPLE_ERROR_CORRECTION  = 0x02;

    /**
     * We only provide a static method ({@link #dither}
     * and don't want to be instantiated.
     */
    private Dither() {
    }

    /**
     * Analize and reduce the number of colors of the given image. Depending
     * on the image and the algorithm, the result may be a new BufferedImage
     * or the same simply returned. If the number of colors in the image is
     * less than required number, no image manipulation is done and the same
     * image is returned.
     *
     * @param image The BufferedImage to analize for color reduction
     * @param nCol The maximum number of colors allowed in the result
     * @param transparency The transparency color of the image or -1 if there
     *         is no specific transparency color.
     * @param bgcolor The background color. This - if not -1 - is mixed into
     *         the image before reducing colors.
     * @param algorithm Indicate the dithering algorithm to use. Take one of
     *            the above constants
     *
     * @return The same image if no color reduction is needed or a new one
     *    if color reduction was needed.
     *
     * @see #DITHER_NONE
     * @see #DITHER_SIMPLE_ERROR_CORRECTION
     *
     * @deprecated as of Communiqu� 3.1.0, use com.day.image.DitherOp instead,
     * 		this class will be removed in the next release.
     */
    @Deprecated
    public static BufferedImage dither(BufferedImage image, int nCol,
	long transparency, long bgcolor, int algorithm) {

	Color transparentCol = (transparency == -1) ? null
	                    : new Color((int)transparency, true);
	Color bgCol = (bgcolor == -1) ? null
	            : new Color((int)bgcolor, true);

	DitherOp.DitherAlgorithm algo = (algorithm == DITHER_SIMPLE_ERROR_CORRECTION)
	             ? DitherOp.DITHER_SIMPLE_ERROR_CORRECTION
		     : DitherOp.DITHER_NONE;

	DitherOp dither = new DitherOp(nCol, transparentCol, bgCol, algo, null);
	return dither.filter(image, null);
    }

}