/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.util;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * The <code>EnumerationIterator</code> implements an <code>Iterator</code> that
 * iterates over a given <code>Enumeration</code>. This is usefull, when needing
 * an <code>Iterator</code> but having an <code>Enumeration</code>.
 *
 * @version $Revision: 1.7 $
 * @author tripod
 * @since antbear
 * Audience wad
 */
public class EnumerationIterator implements Iterator {

    /** the internal enumeratrion */
    private final Enumeration delegatee;

    /**
     * Constructs an <code>EnuerationIterator</code>
     * @param delegatee the underlaying enumeration
     */
    public EnumerationIterator(Enumeration delegatee) {
        this.delegatee = delegatee;
    }

    /**
     * @see Iterator#hasNext()
     */
    public boolean hasNext() {
        return delegatee.hasMoreElements();
    }

    /**
     * @see Iterator#next()
     */
    public Object next() {
        return delegatee.nextElement();
    }

    /**
     * Always throws <code>UnsupportedOperationException</code>.
     *
     * @see Iterator#remove()
     */
    public void remove() {
        throw new UnsupportedOperationException();
    }
}
