/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.util;

import java.io.File;

/**
 * An <code>ExecutionContext</code> contains temporary objects. When the
 * context is destroyed, its attached temporary objects are destroyed.
 *
 * Audience dev
 * @version $Revision: 1.5 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author dpfister
 * @since antbear
 */
public interface ExecutionContext {

    /**
     * Add a generic temporary object that implements the {@link Finalizer}
     * interface. Its {@link Finalizer#doFinalize()} method will be called
     * when the <code>ExecutionContext</code> is destroyed.
     * @param object the object to register
     */
    public void registerObject(Finalizer object);

    /**
     * Add a temporary file to this <code>ExecutionContext</code>. The
     * temporary file will be deleted when the context is destroyed.
     * @param file file to remember
     */
    public void addTempFile(File file);
}
