/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.util;

import java.util.*;

/**
 * Simple implementation of a List which has elements also retreivable by a key.
 *
 * @version $Revision: 1.7 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $ 
 * @author benp
 * @since antbear
 * Audience core
 */
public class ListMap {

    private List list = null;   // List of Entrys {key, value}
    private Map  map  = null;      // Map  of key -> value  where key, value are a pair in the list.

    public ListMap() {
	list = new LinkedList();  // Good for iterating
	map  = new HashMap();     // Good for lookups
    }
    public ListMap(int size) {
	list = new LinkedList();
	map  = new HashMap(size);
    }

    public int size() {
	return list.size();
    }

    public Iterator iterator() {
	return list.iterator();
    }

    public int put(Object key, Object value) {
	if (map.get(key) != null) {
	    throw new java.lang.IllegalArgumentException("Key '" + key + "' already exists in the ListMap.");
	}
	map.put(key, value);
	list.add(new Entry(key, value));
	return list.size() - 1;
    }

    public Object get(Object key) {
	return map.get(key);
    }

    public Entry get(int index) {
	return (Entry)list.get(index);
    }

    public boolean isEmpty() {
	return list.isEmpty();
    }

    public void clear() {
	list.clear();
	map.clear();
    }

    public String toString() {

	String buf = "";
	for (Iterator listIf = list.iterator(); listIf.hasNext();) {
	    Entry entry = (Entry) listIf.next();

	    if (entry.val instanceof ListMap) {
		buf += "" + entry.key + "= (ListMap):\n" + ((ListMap)(entry.val)).toString(1);
	    }
	    else {
		buf += "" + entry.key + "=" + entry.getValue() + "\n";
	    }
	}

	return buf;
    }

    private String toString(int indent) {
	String buf = "";

	String white = "";
	for (int i=0; i<indent; i++) {
	    white += "  ";
	}

	for (Iterator listIf = list.iterator(); listIf.hasNext();) {
	    Entry entry = (Entry) listIf.next();

	    if (entry.val instanceof ListMap) {
		buf += white + entry.key + "=\n" + ((ListMap)(entry.val)).toString(indent + 1);
	    }
	    else {
		buf += white + entry.key + "=" + entry.val + "\n";
	    }
	}
	return buf;
    }

    public Entry getLast() {
	if (list.size() == 0) { return null; }
	return (Entry)list.get(list.size()-1);
    }

    public class Entry {
	public Entry(Object key, Object val) {
	    this.key = key;
	    this.val = val;
	}
	private Object key = null;
	private Object val = null;
	public Object getKey() { return key; }
	public Object getValue() { return val; }
    }
}
