/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.util;

/**
 * This class provides some mathematical utilities that extends those of
 * {@link java.lang.Math}.
 *
 * @version $Revision: 1.7 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author fmeschbe
 * @since antbear
 * Audience wad
 */

public final class Math {

    private Math() {
    }

    /**
     * Returns the smallest of the three argument values.
     *
     * @param a The first value
     * @param b The second value
     * @param c The third value
     *
     * @return The smallest value of the three
     */
    public static final int min3(int a, int b, int c) {
	return (a<b ? (a<c ? a : c ) : (b<c ? b : c));
    }

    /**
     * Returns the largest of the three argument values.
     *
     * @param a The first value
     * @param b The second value
     * @param c The third value
     *
     * @return The largest value of the three
     */
    public static final int max3(int a, int b, int c) {
	return (a>b ? (a>c ? a : c ) : (b>c ? b : c));
    }

    /**
     * Returns the smallest of the three argument values.
     *
     * @param a The first value
     * @param b The second value
     * @param c The third value
     *
     * @return The smallest value of the three
     */
    public static final double min3(double a, double b, double c) {
	return (a<b ? (a<c ? a : c ) : (b<c ? b : c));
    }

    /**
     * Returns the largest of the three argument values.
     *
     * @param a The first value
     * @param b The second value
     * @param c The third value
     *
     * @return The largest value of the three
     */
    public static final double max3(double a, double b, double c) {
	return (a>b ? (a>c ? a : c ) : (b>c ? b : c));
    }

}
