/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.util;

import java.io.File;

/**
 * Finalizer that works with temporary files in conjunction with
 * a <code>FinalizerHandler</code>
 *
 * Audience core
 * @version $Revision: 1.9 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author dpfister
 * @since antbear
 */
public final class TempFileFinalizer implements Finalizer {

    /** Temporary file to destroy when this finalizer is called */
    private final File tempFile;

    /**
     * Create a new <code>TempFileFinalizer</code>
     * @param tempFile the temp file
     */
    public TempFileFinalizer(File tempFile) {
	this.tempFile = tempFile;
    }

    /**
     * This is the method called by the {@link FinalizerHandler} when the
     * finalizing work has to be done.
     */
    public void doFinalize() {
	tempFile.delete();
    }
}
