/*
 * Copyright (C) 2012 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;

/**
 *  An {@link ImmutableAsList} implementation specialized for when the delegate collection is
 *  already backed by an {@code ImmutableList} or array.
 *
 *  @author Louis Wasserman
 *
 * @deprecated The Google Guava Core Libraries are deprecated and will not be part of the AEM SDK after April 2023
 */
@GwtCompatible(emulated = true)
// uses writeReplace, not default serialization
@SuppressWarnings("serial")
@Deprecated(since = "2022-12-01")
class RegularImmutableAsList<E> extends ImmutableAsList<E> {

    private final ImmutableCollection<E> delegate;

    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.<E>asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return delegateList;
    }

    // safe covariant cast!
    @SuppressWarnings("unchecked")
    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return (UnmodifiableListIterator<E>) delegateList.listIterator(index);
    }

    @GwtIncompatible("not present in emulated superclass")
    @Override
    int copyIntoArray(Object[] dst, int offset) {
        return delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index) {
        return delegateList.get(index);
    }
}
