/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.util;

import com.adobe.agl.impl.ICUDebug;
import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.util.MeasureUnit;
import com.adobe.agl.util.ULocale;
import com.adobe.agl.util.UResourceBundle;
import java.io.Serializable;
import java.text.ChoiceFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.MissingResourceException;

public class Currency
extends MeasureUnit
implements Serializable {
    private static final boolean DEBUG = ICUDebug.enabled("currency");
    private String isoCode;
    private static ServiceShim shim;
    private static final int[] LAST_RESORT_DATA;
    private static final int[] POW10;

    public static Currency getInstance(ULocale locale) {
        String currency = locale.getKeywordValue("currency");
        if (currency != null) {
            return Currency.getInstance(currency);
        }
        if (shim == null) {
            return Currency.createCurrency(locale);
        }
        return shim.createInstance(locale);
    }

    static Currency createCurrency(ULocale loc) {
        String country = loc.getCountry();
        String variant = loc.getVariant();
        boolean isPreEuro = variant.equals("PREEURO");
        boolean isEuro = variant.equals("EURO");
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        if (bundle == null) {
            return null;
        }
        try {
            UResourceBundle cm = bundle.get("CurrencyMap");
            String curriso = null;
            UResourceBundle countryArray = cm.get(country);
            UResourceBundle currencyReq = countryArray.get(0);
            curriso = currencyReq.getString("id");
            if (isPreEuro && curriso.equals("EUR")) {
                currencyReq = countryArray.get(1);
                curriso = currencyReq.getString("id");
            } else if (isEuro) {
                curriso = "EUR";
            }
            if (curriso != null) {
                return new Currency(curriso);
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return null;
    }

    public static Currency getInstance(String theISOCode) {
        if (theISOCode == null) {
            throw new NullPointerException("The input currency code is null.");
        }
        boolean is3alpha = true;
        if (theISOCode.length() != 3) {
            is3alpha = false;
        } else {
            for (int i = 0; i < 3; ++i) {
                char ch = theISOCode.charAt(i);
                if (ch >= 'A' && (ch <= 'Z' || ch >= 'a') && ch <= 'z') continue;
                is3alpha = false;
                break;
            }
        }
        if (!is3alpha) {
            throw new IllegalArgumentException("The input currency code is not 3-letter alphabetic code.");
        }
        return new Currency(theISOCode.toUpperCase(Locale.US));
    }

    public int hashCode() {
        return this.isoCode.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        try {
            Currency c = (Currency)rhs;
            return this.isoCode.equals(c.isoCode);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getCurrencyCode() {
        return this.isoCode;
    }

    public String getName(ULocale locale, int nameStyle, boolean[] isChoiceFormat) {
        if (nameStyle < 0 || nameStyle > 1) {
            throw new IllegalArgumentException();
        }
        String s = null;
        try {
            UResourceBundle rb = UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", locale);
            ICUResourceBundle currencies = (ICUResourceBundle)rb.get("Currencies");
            s = currencies.getWithFallback(this.isoCode).getString(nameStyle);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        isChoiceFormat[0] = false;
        if (s != null) {
            int i;
            for (i = 0; i < s.length() && s.charAt(i) == '=' && i < 2; ++i) {
            }
            boolean bl = isChoiceFormat[0] = i == 1;
            if (i != 0) {
                s = s.substring(1);
            }
            return s;
        }
        return this.isoCode;
    }

    public static String parse(ULocale locale, String text, ParsePosition pos) {
        int start = pos.getIndex();
        String fragment = text.substring(start);
        String iso = null;
        int max = 0;
        while (locale != null) {
            UResourceBundle rb = UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", locale);
            try {
                UResourceBundle currencies = rb.get("Currencies");
                for (int i = 0; i < currencies.getSize(); ++i) {
                    UResourceBundle item = currencies.get(i);
                    String name = item.getString(0);
                    if (name.length() < 1) continue;
                    if (name.charAt(0) == '=' && (name = name.substring(1)).length() > 0 && name.charAt(0) != '=') {
                        ChoiceFormat choice = new ChoiceFormat(name);
                        choice.parse(text, pos);
                        int len = pos.getIndex() - start;
                        if (len > max) {
                            iso = item.getKey();
                            max = len;
                        }
                        pos.setIndex(start);
                        continue;
                    }
                    if (name.length() <= max || !fragment.startsWith(name)) continue;
                    iso = item.getKey();
                    max = name.length();
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            locale = locale.getFallback();
        }
        if (max < 3 && text.length() - start >= 3) {
            boolean valid = true;
            for (int k = 0; k < 3; ++k) {
                char ch = text.charAt(start + k);
                if (ch >= 'A' && ch <= 'Z') continue;
                valid = false;
                break;
            }
            if (valid) {
                iso = text.substring(start, start + 3);
                max = 3;
            }
        }
        pos.setIndex(start + max);
        return iso;
    }

    public int getDefaultFractionDigits() {
        return this.findData()[0];
    }

    public double getRoundingIncrement() {
        int[] data = this.findData();
        int data1 = data[1];
        if (data1 == 0) {
            return 0.0;
        }
        int data0 = data[0];
        if (data0 < 0 || data0 >= POW10.length) {
            return 0.0;
        }
        return (double)data1 / (double)POW10[data0];
    }

    public String toString() {
        return this.isoCode;
    }

    protected Currency(String theISOCode) {
        this.isoCode = theISOCode;
    }

    private int[] findData() {
        try {
            UResourceBundle root = ICUResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle currencyMeta = root.get("CurrencyMeta");
            int[] i = currencyMeta.get(this.isoCode).getIntVector();
            if (i == null) {
                i = currencyMeta.get("DEFAULT").getIntVector();
            }
            if (i != null && i.length >= 2) {
                return i;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return LAST_RESORT_DATA;
    }

    static {
        LAST_RESORT_DATA = new int[]{2, 0};
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    static abstract class ServiceShim {
        abstract Currency createInstance(ULocale var1);
    }
}

