/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.mcm.campaign.profile;

import com.adobe.cq.mcm.campaign.profile.MetaDataNode;
import com.adobe.cq.mcm.campaign.profile.MetaDataRetriever;
import com.adobe.cq.mcm.campaign.profile.OptionValue;
import com.adobe.cq.mcm.campaign.profile.Options;
import com.adobe.cq.mcm.campaign.profile.Profile;
import com.adobe.cq.mcm.campaign.profile.ProfileRetriever;
import com.day.cq.mcm.campaign.ACConnectorException;
import com.day.cq.mcm.campaign.Defs;
import com.day.cq.mcm.campaign.profile.Subscriptions;
import com.day.cq.mcm.campaign.profile.SubscriptionsManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileHelper {
    private static final String ATTRIB_METADATA = MetaDataNode.class.toString();
    private static final String ATTRIB_PROFILE = Profile.class.toString();
    private static final String ATTRIB_SUBSCRIPTIONS = Subscriptions.class.toString();
    private static final Logger log = LoggerFactory.getLogger(ProfileHelper.class);

    private ProfileHelper() {
    }

    private static Resource searchFormStart(Resource resource) {
        Resource current;
        if (resource.getName().equals("jcr:content")) {
            return null;
        }
        if (resource.getPath().lastIndexOf("/") == 0) {
            return null;
        }
        if (ResourceUtil.isA(resource, "foundation/components/form/start")) {
            return resource;
        }
        Resource parent = resource.getParent();
        ArrayList<Resource> predecessor = new ArrayList<Resource>();
        Iterator<Resource> children = parent.listChildren();
        while (children.hasNext() && !(current = children.next()).getPath().equals(resource.getPath())) {
            predecessor.add(current);
        }
        Collections.reverse(predecessor);
        for (Resource current2 : predecessor) {
            if (ResourceUtil.isA(current2, "foundation/components/form/start")) {
                return current2;
            }
            if (!ResourceUtil.isA(current2, "foundation/components/form/end")) continue;
            return null;
        }
        return ProfileHelper.searchFormStart(parent);
    }

    public static MetaDataNode getMetaData(SlingHttpServletRequest request) throws ACConnectorException {
        MetaDataNode metaData = (MetaDataNode)request.getAttribute(ATTRIB_METADATA);
        if (metaData == null) {
            SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
            if (bindings == null) {
                throw new ACConnectorException("No sling bindings available - utility class is meant to be usedfrom Sling scripts only.");
            }
            MetaDataRetriever retriever = bindings.getSling().getService(MetaDataRetriever.class);
            if (retriever == null) {
                throw new ACConnectorException("Could not determine 'MetaDataRetriever2' service.");
            }
            Resource resource = request.getResource();
            PageManager pageManager = resource.getResourceResolver().adaptTo(PageManager.class);
            Page page = pageManager.getContainingPage(resource);
            if (page == null) {
                throw new ACConnectorException("Resource '" + resource.getPath() + "' is not part of a page.");
            }
            metaData = retriever.retrieve(page.adaptTo(Resource.class));
            request.setAttribute(ATTRIB_METADATA, metaData);
        }
        return metaData;
    }

    public static MetaDataNode getMetaDataByPath(SlingHttpServletRequest request, String path) throws ACConnectorException {
        MetaDataNode root = ProfileHelper.getMetaData(request);
        if (root != null && path.startsWith("/")) {
            String relPath = path.substring(1);
            return root.getChildByPath(relPath);
        }
        return null;
    }

    public static Options getOptions(SlingHttpServletRequest request) throws ACConnectorException {
        MetaDataNode data;
        String path;
        ValueMap values = request.getResource().adaptTo(ValueMap.class);
        String mapping = (String)((Object)values.get("acMapping", String.class));
        String string = path = mapping == null || mapping.startsWith("/") ? mapping : "/" + mapping.replaceAll("\\.", "/");
        if (path != null && (data = ProfileHelper.getMetaDataByPath(request, path)) != null) {
            return data.hasOptions() ? data.getOptions() : null;
        }
        return null;
    }

    public static Map<String, String> getOptionsAsMap(SlingHttpServletRequest request) {
        LinkedHashMap<String, String> optionsMap = null;
        try {
            Options options = ProfileHelper.getOptions(request);
            if (options != null) {
                optionsMap = new LinkedHashMap<String, String>(4);
                Iterator<OptionValue> values = options.getValues();
                while (values.hasNext()) {
                    OptionValue value = values.next();
                    optionsMap.put(value.getValue(), value.getLabel());
                }
            }
        }
        catch (ACConnectorException e) {
            log.warn("Could not determine options", e);
        }
        return optionsMap;
    }

    public static Profile getProfile(SlingHttpServletRequest request, String encryptedPK) throws ACConnectorException {
        Profile profile = (Profile)request.getAttribute(ATTRIB_PROFILE);
        if (profile == null) {
            MetaDataNode metaData = ProfileHelper.getMetaData(request);
            SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
            if (bindings == null) {
                throw new ACConnectorException("No sling bindings available - utility class is meant to be usedfrom Sling scripts only.");
            }
            ProfileRetriever retriever = bindings.getSling().getService(ProfileRetriever.class);
            if (retriever == null) {
                throw new ACConnectorException("Could not determine 'ProfileRetriever2' service.");
            }
            Resource resource = request.getResource();
            PageManager pageManager = resource.getResourceResolver().adaptTo(PageManager.class);
            Page page = pageManager.getContainingPage(resource);
            if (page == null) {
                throw new ACConnectorException("Resource '" + resource.getPath() + "' is not part of a page.");
            }
            profile = retriever.load(page.adaptTo(Resource.class), encryptedPK, metaData);
            request.setAttribute(ATTRIB_PROFILE, profile);
        }
        return profile;
    }

    public static String determineEncryptedPK(SlingHttpServletRequest request) {
        log.debug("Determining encrypted PK");
        Resource resource = request.getResource();
        Resource form = ProfileHelper.searchFormStart(resource);
        if (form == null) {
            log.debug("Form resource not found");
            return null;
        }
        log.debug("Form resource: {}", (Object)form.getPath());
        Iterator<Resource> fields = FormsHelper.getFormElements(form);
        while (fields.hasNext()) {
            Resource field = fields.next();
            log.debug("Processing component '{}' ({})", new String[]{field.getName(), field.getResourceType()});
            if (!ResourceUtil.isA(field, "mcm/campaign/components/form/profile/encryptedPK")) continue;
            log.debug("Encrypted PK field found: {}" + field.getName());
            ValueMap values = ResourceUtil.getValueMap(field);
            String urlParameter = (String)((Object)values.get("urlParameter", String.class));
            if (urlParameter == null) {
                log.debug("Missing property 'urlParameter'");
                return null;
            }
            log.debug("URL parameter for encrypted PK is: {}", (Object)urlParameter);
            return request.getParameter(urlParameter);
        }
        return null;
    }

    public static Profile getProfile(SlingHttpServletRequest request) throws ACConnectorException {
        Profile profile = (Profile)request.getAttribute(ATTRIB_PROFILE);
        if (profile == null) {
            log.debug("Loading profile data from Adobe Campaign instance.");
            String encryptedPK = ProfileHelper.determineEncryptedPK(request);
            log.debug("Encrypted primary key: {}", (Object)encryptedPK);
            if (encryptedPK != null) {
                profile = ProfileHelper.getProfile(request, encryptedPK);
            }
        }
        return profile;
    }

    public static MetaDataNode getMetaDataInstance(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        try {
            log.debug("Profile received successfully,");
            MetaDataNode metaData = ProfileHelper.getMetaData(request);
            if (metaData == null) {
                return null;
            }
            log.debug("Meta data received successfully,");
            ValueMap values = ResourceUtil.getValueMap(resource);
            String mapping = (String)((Object)values.get("acMapping", String.class));
            if (mapping == null) {
                return null;
            }
            log.debug("Mapping determined successfully: {}", (Object)mapping);
            if (!mapping.startsWith("/")) {
                mapping = "/" + mapping.replaceAll("\\.", "/");
            }
            return ProfileHelper.getMetaDataByPath(request, mapping);
        }
        catch (ACConnectorException e) {
            log.warn("Could not determine meta data instance.", e);
            return null;
        }
    }

    public static Object getValue(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        String name = FormsHelper.getParameterName(resource);
        ValidationInfo info = ValidationInfo.getValidationInfo(request);
        if (info != null) {
            log.debug("Validation info found for field '{}'", (Object)name);
            String[] valuesArray = info.getValues(name);
            if (valuesArray.length == 1) {
                log.debug("Taking value from validation info: {}", (Object)valuesArray[0]);
                return valuesArray[0];
            }
        }
        Object value = null;
        try {
            MetaDataNode node;
            log.debug("Determining profile value.");
            Profile profile = ProfileHelper.getProfile(request);
            if (profile != null && (node = ProfileHelper.getMetaDataInstance(request)) != null) {
                log.debug("MetaDataNode: {}", (Object)node.getPath());
                value = profile.getValue(node);
                log.debug("Profile value: {}", value);
            }
        }
        catch (ACConnectorException e) {
            log.warn("Could not determine profile", e);
        }
        return value;
    }

    public static List<String> getValuesAsList(SlingHttpServletRequest request) {
        ArrayList<String> values = new ArrayList<String>(1);
        Object value = ProfileHelper.getValue(request);
        if (value != null && value instanceof String) {
            values.add((String)value);
        }
        return values;
    }

    public static boolean isReconciliationKey(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        ValueMap values = ResourceUtil.getValueMap(resource);
        return values != null && "true".equals(values.get("acReconciliationKey", String.class));
    }

    public static boolean getValueAsBoolean(SlingHttpServletRequest request) {
        Object valueObj = ProfileHelper.getValue(request);
        if (valueObj != null) {
            if (valueObj instanceof Boolean) {
                return (Boolean)valueObj;
            }
            if (valueObj instanceof String) {
                String valueStr = (String)valueObj;
                for (String trueValue : Defs.BOOLEAN_TRUE_VALUES) {
                    if (!valueStr.equals(trueValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getBooleanTrue(SlingHttpServletRequest request) {
        Object valueObj = ProfileHelper.getValue(request);
        if (valueObj == null || !(valueObj instanceof String)) {
            return "true";
        }
        String valueStr = (String)valueObj;
        for (String trueValue : Defs.BOOLEAN_TRUE_VALUES) {
            if (!valueStr.equals(trueValue)) continue;
            return trueValue;
        }
        int i = 0;
        for (String falseValue : Defs.BOOLEAN_FALSE_VALUES) {
            if (valueStr.equals(falseValue)) {
                return Defs.BOOLEAN_TRUE_VALUES[i];
            }
            ++i;
        }
        return "true";
    }

    public static String getBooleanFalse(SlingHttpServletRequest request) {
        Object valueObj = ProfileHelper.getValue(request);
        if (valueObj == null || !(valueObj instanceof String)) {
            return "false";
        }
        String valueStr = (String)valueObj;
        for (String falseValue : Defs.BOOLEAN_FALSE_VALUES) {
            if (!valueStr.equals(falseValue)) continue;
            return falseValue;
        }
        int i = 0;
        for (String trueValue : Defs.BOOLEAN_TRUE_VALUES) {
            if (valueStr.equals(trueValue)) {
                return Defs.BOOLEAN_FALSE_VALUES[i];
            }
            ++i;
        }
        return "false";
    }

    public static Subscriptions getSubscriptions(SlingHttpServletRequest req) {
        Subscriptions subscriptions = (Subscriptions)req.getAttribute(ATTRIB_SUBSCRIPTIONS);
        if (subscriptions == null) {
            try {
                SlingBindings bindings = (SlingBindings)req.getAttribute(SlingBindings.class.getName());
                if (bindings == null) {
                    throw new ACConnectorException("No sling bindings available - utility class is meant to be used from Sling scripts only.");
                }
                SubscriptionsManager sm = bindings.getSling().getService(SubscriptionsManager.class);
                if (sm == null) {
                    throw new ACConnectorException("Could not determine 'SubscriptionsManager' service.");
                }
                Resource resource = req.getResource();
                PageManager pageManager = resource.getResourceResolver().adaptTo(PageManager.class);
                Page page = pageManager.getContainingPage(resource);
                if (page == null) {
                    throw new ACConnectorException("Resource '" + resource.getPath() + "' is not part of a page.");
                }
                subscriptions = sm.retrieve(page.adaptTo(Resource.class));
                req.setAttribute(ATTRIB_SUBSCRIPTIONS, subscriptions);
            }
            catch (ACConnectorException ace) {
                log.warn("Could not determine subscriptions: {}", (Object)ace.getMessage());
                subscriptions = null;
            }
        }
        return subscriptions;
    }
}

