/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.msm.ui.models.alllivecopies;

import com.adobe.cq.msm.ui.models.alllivecopies.LiveCopiesCell;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LiveCopiesRow {
    private String rowPath;
    private String rowTitle;
    private List<LiveCopiesCell> cells;
    private Map<String, String> rowAttrs;
    private boolean isPage;
    private String thumbnailPath;
    private String actionRels;
    private String relPath;

    public LiveCopiesRow(String resourcePath, String resourceName, String relPath) {
        this.isPage = false;
        this.cells = Collections.emptyList();
        this.rowPath = resourcePath;
        this.rowTitle = resourceName;
        this.rowAttrs = this.setRowAttributes(this.rowPath);
        this.thumbnailPath = "";
        this.actionRels = "";
        this.relPath = relPath;
    }

    public LiveCopiesRow(Boolean isPage, String rowPath, String rowTitle, List<LiveCopiesCell> cells, String thumbnailPath, String actionRels, String relPath) {
        this.isPage = isPage;
        this.cells = cells;
        this.rowPath = rowPath;
        this.rowTitle = rowTitle;
        this.rowAttrs = this.setRowAttributes(rowPath);
        this.thumbnailPath = thumbnailPath;
        this.actionRels = actionRels;
        this.relPath = relPath;
    }

    public boolean isPage() {
        return this.isPage;
    }

    public String getRowPath() {
        return this.rowPath;
    }

    public String getRowTitle() {
        return this.rowTitle;
    }

    public List<LiveCopiesCell> getCells() {
        return this.cells;
    }

    public Map<String, String> getRowAttrs() {
        return this.rowAttrs;
    }

    public String getThumbnailPath() {
        if (this.isPage) {
            return this.thumbnailPath;
        }
        return null;
    }

    public String getActionRels() {
        return this.actionRels;
    }

    public String getRelPath() {
        return this.relPath;
    }

    public boolean isRolloutHierarchicalResource() {
        return this.isPage;
    }

    private Map<String, String> setRowAttributes(String rowPath) {
        HashMap<String, String> rowAttrs = new HashMap<String, String>();
        rowAttrs.put("is", "coral-table-row");
        rowAttrs.put("data-foundation-collection-item-id", rowPath);
        if (this.isRolloutHierarchicalResource()) {
            rowAttrs.put("selectable", "selectable");
        }
        rowAttrs.put("data-path", rowPath);
        return rowAttrs;
    }
}

