/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class SubsetSimpleTrueType {
    private final int mPlatformID;
    private final int mPlatformSpecificID;
    private final int[] mCodePoints;
    private final String[] mPostNames;

    public SubsetSimpleTrueType(int platformID, int platformSpecificID, int[] codePoints, String[] postNames) {
        this.mPlatformID = platformID;
        this.mPlatformSpecificID = platformSpecificID;
        ArrayList<Integer> cps = new ArrayList<Integer>();
        for (int i = 0; i < codePoints.length; ++i) {
            if (codePoints[i] <= 0) continue;
            cps.add(new Integer(codePoints[i]));
        }
        Collections.sort(cps);
        int lastCP = -1;
        Iterator iter = cps.iterator();
        while (iter.hasNext()) {
            int thisCP = (Integer)iter.next();
            if (thisCP == lastCP) {
                iter.remove();
            }
            lastCP = thisCP;
        }
        codePoints = new int[cps.size()];
        for (int i = 0; i < cps.size(); ++i) {
            codePoints[i] = (Integer)cps.get(i);
        }
        this.mCodePoints = codePoints;
        this.mPostNames = postNames;
    }

    public int getPlatformID() {
        return this.mPlatformID;
    }

    public int getPlatformSpecificID() {
        return this.mPlatformSpecificID;
    }

    public int[] getCodePoints() {
        return this.mCodePoints;
    }

    public String[] getPostNames() {
        return this.mPostNames;
    }
}

