/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.CFFSubrize;
import com.adobe.fontengine.font.cff.CIDComponentFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Charset;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.FdSelect;
import com.adobe.fontengine.font.cff.Header;
import com.adobe.fontengine.font.cff.Index;
import com.adobe.fontengine.font.cff.NameIndex;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.Type2OutlineParser;
import com.adobe.fontengine.font.postscript.UnicodeCmap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class CIDKeyedFont
extends CFFFont {
    protected final CharStrings charStrings;
    protected final Charset charset;
    protected final FdSelect fdSelect;
    protected final CIDComponentFont[] components;
    private final XDCFontDescription xdcDescription;
    UnicodeCmap cmap = null;
    Object cmapMutex = new Object();
    static final Dict.Key[] topDictKeysForSubset = new Dict.Key[]{Dict.Key.Notice, Dict.Key.FullName, Dict.Key.FamilyName, Dict.Key.FontName, Dict.Key.BaseFontName, Dict.Key.BaseFontBlend, Dict.Key.Weight, Dict.Key.FontBBox, Dict.Key.Copyright, Dict.Key.isFixedPitch, Dict.Key.ItalicAngle, Dict.Key.UnderlinePosition, Dict.Key.UnderlineThickness, Dict.Key.PaintType, Dict.Key.CharstringType, Dict.Key.StrokeWidth, Dict.Key.CIDFontType};
    static final Dict.Key[] fontDictKeysForSubset = new Dict.Key[]{Dict.Key.FontMatrix};
    static final Dict.Key[] privateDictKeysForSubset = new Dict.Key[]{Dict.Key.BlueValues, Dict.Key.OtherBlues, Dict.Key.FamilyBlues, Dict.Key.FamilyOtherBlues, Dict.Key.StdHW, Dict.Key.StdVW, Dict.Key.defaultWidthX, Dict.Key.nominalWidthX, Dict.Key.BlueScale, Dict.Key.BlueShift, Dict.Key.BlueFuzz, Dict.Key.StemSnapH, Dict.Key.StemSnapV, Dict.Key.ForceBold, Dict.Key.ForceBoldThreshold, Dict.Key.LanguageGroup, Dict.Key.ExpansionFactor, Dict.Key.initialRandomSeed};
    private static final int MAX_CFF_SIZE_FOR_SUBRIZE = 614400;

    @Override
    public Subset createSubset() throws InvalidFontException, UnsupportedFontException {
        SubsetDefaultImpl s = new SubsetDefaultImpl(this.getNumGlyphs(), true);
        s.getSubsetGid(0);
        return s;
    }

    CIDKeyedFont(StringIndex stringIndex, CharStrings globalSubrs, String name, Dict topDict, CFFByteArray data, byte[] digest) throws InvalidFontException, UnsupportedFontException {
        super(stringIndex, globalSubrs, topDict, name, digest);
        this.xdcDescription = new CIDKeyedFontXDCFontDescription();
        Dict.OffsetValue o = topDict.get(Dict.Key.CharStrings, false);
        if (o == null) {
            throw new InvalidFontException("missing TopDICT/CharStrings");
        }
        this.charStrings = new CharStrings(data, o.offset);
        int numGlyphs = this.charStrings.getCount();
        Dict.OffsetValue o2 = topDict.get(Dict.Key.charset, false);
        this.charset = o2 != null ? new Charset(data, o2.offset, numGlyphs) : new Charset(null, -1, 0);
        CIDComponentFont[] components = null;
        Dict.OffsetValue o3 = topDict.get(Dict.Key.FDArray, false);
        if (o3 != null) {
            Index fontDictIndex = new Index(data, o3.offset);
            components = new CIDComponentFont[fontDictIndex.getCount()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = new CIDComponentFont(data, fontDictIndex.offsetOf(i), fontDictIndex.sizeOf(i), stringIndex);
            }
        }
        this.components = components;
        FdSelect fdSelect = null;
        Dict.OffsetValue v = topDict.get(Dict.Key.FDSelect, false);
        if (v != null) {
            fdSelect = new FdSelect(data, v.offset, numGlyphs);
        }
        this.fdSelect = fdSelect;
    }

    CIDKeyedFont(StringIndex stringIndex, CharStrings globalSubrs, String name, Dict topDict, CharStrings charStrings, Charset charset, CIDComponentFont[] components, FdSelect fdSelect) throws UnsupportedFontException, InvalidFontException {
        super(stringIndex, globalSubrs, topDict, name, null);
        this.xdcDescription = new CIDKeyedFontXDCFontDescription();
        this.charStrings = charStrings;
        this.charset = charset;
        this.components = (CIDComponentFont[])components.clone();
        this.fdSelect = fdSelect;
    }

    public CIDKeyedFont(String name, Dict topDict, CharStrings charStrings, int numGlyphs, Dict ciddict, Dict privateDict) throws InvalidFontException, UnsupportedFontException {
        super(null, CharStrings.createEmptyCharstrings(), topDict, name, null);
        this.xdcDescription = new CIDKeyedFontXDCFontDescription();
        CIDComponentFont[] components = new CIDComponentFont[]{new CIDComponentFont(ciddict, privateDict, CharStrings.createEmptyCharstrings())};
        this.charStrings = charStrings;
        this.charset = Charset.identityCharset(numGlyphs);
        this.components = components;
        this.fdSelect = FdSelect.singleFont(numGlyphs);
    }

    public CIDKeyedFont(String name, Dict topDict, CharStrings charStrings, int numGlyphs, Dict cidDict, Dict privateDict, CharStrings lSubrs, CharStrings gSubrs) throws InvalidFontException, UnsupportedFontException {
        super(null, gSubrs, topDict, name, null);
        this.xdcDescription = new CIDKeyedFontXDCFontDescription();
        CIDComponentFont[] components = new CIDComponentFont[]{new CIDComponentFont(cidDict, privateDict, lSubrs)};
        this.charStrings = charStrings;
        this.charset = Charset.identityCharset(numGlyphs);
        this.components = components;
        this.fdSelect = FdSelect.singleFont(numGlyphs);
    }

    @Override
    public int getNumGlyphs() {
        return this.charStrings.getCount();
    }

    @Override
    public String getGlyphName(int gid) {
        return null;
    }

    @Override
    public ROS getROS() {
        return this.topDict.getROS();
    }

    public int getCIDCount() {
        return this.topDict.get((Dict.IntegerKey)Dict.Key.CIDCount, (boolean)true).value;
    }

    @Override
    public int getGlyphCid(int gid) throws InvalidFontException, UnsupportedFontException {
        return this.charset.gid2sid(gid);
    }

    public int cid2gid(int cid) throws InvalidFontException, UnsupportedFontException {
        return this.charset.sid2gid(cid);
    }

    @Override
    int[] getXUID() {
        Dict.NumbersValue v = this.topDict.get(Dict.Key.XUID, true);
        return v == null ? null : v.getValuesAsInt();
    }

    @Override
    String getNotice() {
        Dict.StringValue value = this.topDict.get(Dict.Key.Notice, true);
        return value == null ? null : value.value;
    }

    @Override
    String getCopyright() {
        Dict.StringValue value = this.topDict.get(Dict.Key.Copyright, true);
        return value == null ? null : value.value;
    }

    @Override
    String getFullName() {
        Dict.StringValue value = this.topDict.get(Dict.Key.FullName, true);
        return value == null ? null : value.value;
    }

    @Override
    Integer getFSType() {
        return this.topDict.getFSType();
    }

    @Override
    OrigFontType getOrigFontType() {
        return this.topDict.getOrigFontType();
    }

    @Override
    public void getGlyphOutline(int gid, OutlineConsumer consumer) throws InvalidFontException, UnsupportedFontException {
        if (this.topDict.get(Dict.Key.CharstringType, true).getFirstValueAsDouble() != 2.0) {
            throw new InvalidFontException("Unsupported Charstring type");
        }
        this.getOutline(gid, new Type2OutlineParser(false), consumer);
    }

    @Override
    public void getOutline(int gid, Type2OutlineParser parser, OutlineConsumer consumer) throws InvalidFontException, UnsupportedFontException {
        this.components[this.fdSelect.componentOf(gid)].getOutline(this.charStrings, gid, this.globalSubrs, parser, consumer, this.topDict.get(Dict.Key.FontMatrix, false));
    }

    @Override
    public double getStemVForGlyph(int gid) throws InvalidFontException {
        return this.components[this.fdSelect.componentOf(gid)].getStemV();
    }

    @Override
    public Matrix getFontMatrix() {
        return new Matrix(this.topDict.get(Dict.Key.FontMatrix, true).getValuesAsDouble());
    }

    public Matrix getFontMatrix(int component) {
        Dict.NumbersValue topMatrix = this.topDict.get(Dict.Key.FontMatrix, false);
        Matrix matrix = component >= 0 && component < this.components.length ? this.components[component].getOutlineMatrix(topMatrix) : new Matrix(topMatrix.getValuesAsDouble());
        return matrix;
    }

    private Matrix getFontToMetricsMatrix() throws InvalidFontException, UnsupportedFontException {
        Matrix m = this.getFontMatrix();
        double x = this.getUnitsPerEmX();
        double y = this.getUnitsPerEmY();
        return new Matrix(x * m.a, y * m.b, x * m.c, y * m.d, x * m.tx, y * m.ty);
    }

    @Override
    public double getHorizontalAdvance(int gid) throws InvalidFontException, UnsupportedFontException {
        return this.components[this.fdSelect.componentOf(gid)].getHorizontalAdvance(this.charStrings, gid, this.globalSubrs);
    }

    @Override
    double getItalicAngle() {
        Dict.NumbersValue v = this.topDict.get(Dict.NumbersKey.ItalicAngle, false);
        if (v != null) {
            return v.getFirstValueAsDouble();
        }
        return 0.0;
    }

    @Override
    public Rect getRawFontBBox() {
        Dict.NumbersValue v = this.topDict.get(Dict.NumbersKey.FontBBox, false);
        if (v != null && v.values.length == 4) {
            return new Rect(v.getValuesAsDouble());
        }
        return null;
    }

    private double getCoolTypeLineGapForCJK() throws UnsupportedFontException, InvalidFontException {
        return this.getUnitsPerEmY() / 2.0;
    }

    private LineMetrics getCoolTypeLineMetricsFromTypicalCharacters(double linegap) throws UnsupportedFontException, InvalidFontException {
        double ascender;
        double descender;
        int dGid = this.getCoolTypeGlyphForChar(100);
        int pGid = this.getCoolTypeGlyphForChar(112);
        if (dGid != 0 && pGid != 0 && (descender = this.getGlyphBBox((int)pGid).ymin) < (ascender = this.getGlyphBBox((int)dGid).ymax)) {
            return new LineMetrics(ascender, descender, linegap);
        }
        return null;
    }

    private LineMetrics getCoolTypeLineMetricsFromICFBox(double linegap) throws UnsupportedFontException, InvalidFontException {
        Rect icfBox = this.getCoolTypeIcfBox();
        return new LineMetrics(icfBox.ymax, icfBox.ymax - this.getUnitsPerEmY(), linegap);
    }

    @Override
    public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
        Rect rawBBox = this.getRawFontBBox();
        if (rawBBox == null) {
            return null;
        }
        return rawBBox.applyMatrix(this.getFontToMetricsMatrix());
    }

    @Override
    protected Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException {
        return this.getFontBBox();
    }

    @Override
    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        if (this.useCoolTypeCJKHeuristics()) {
            double linegap = this.getCoolTypeLineGapForCJK();
            LineMetrics lm = this.getCoolTypeLineMetricsFromTypicalCharacters(linegap);
            if (lm != null) {
                return lm;
            }
            return this.getCoolTypeLineMetricsFromICFBox(linegap);
        }
        return this.getCoolTypeLineMetricsFromFontBbox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getFirstSupportedChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getLastSupportedChar();
        }
    }

    private void initCmap() throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            Dict.ROSValue ros = this.topDict.get(Dict.ROSKey.ROS, true);
            this.cmap = UnicodeCmap.computeCmapFromCids(this.getNumGlyphs(), new UnicodeCmap.GlyphCidAccessor(){

                @Override
                public int getAGlyphCid(int gid) throws UnsupportedFontException, InvalidFontException {
                    return CIDKeyedFont.this.charset.gid2sid(gid);
                }
            }, ros.ros.registry, ros.ros.ordering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getGlyphForChar(int usv) throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getGlyphForChar(usv);
        }
    }

    @Override
    public Permission getEmbeddingPermission(boolean wasEmbedded) {
        return this.getEmbeddingPermissionGivenFT(wasEmbedded, OrigFontType.kCID);
    }

    @Override
    int getNumFDs() {
        return this.components.length;
    }

    @Override
    CharStrings getCharStrings() {
        return this.charStrings;
    }

    @Override
    CharStrings getLocalSubrsForFD(int fd) {
        return this.components[fd].localSubrs;
    }

    @Override
    double getDefaultWidthForFD(int fd) {
        return this.components[fd].privateDict.get(Dict.NumbersKey.defaultWidthX, true).getFirstValueAsDouble();
    }

    @Override
    double getNominalWidthForFD(int fd) {
        return this.components[fd].privateDict.get(Dict.NumbersKey.nominalWidthX, true).getFirstValueAsDouble();
    }

    @Override
    int getFDForGlyph(int fullGid) throws InvalidFontException {
        return this.fdSelect.componentOf(fullGid);
    }

    private void setCIDCount(boolean preserveROS, CFFByteArray.CFFByteArrayBuilder bb, Subset subset, boolean doSubset, List strings) throws InvalidFontException, UnsupportedFontException {
        if (!preserveROS) {
            Dict.streamKeyVal(bb, Dict.Key.CIDCount, subset.getNumGlyphs());
        } else if (doSubset) {
            int maxcid = -1;
            for (int i = 0; i < subset.getNumGlyphs(); ++i) {
                int fullGid = subset.getFullGid(i);
                int cid = this.charset.gid2sid(fullGid);
                if (cid <= maxcid) continue;
                maxcid = cid;
            }
            Dict.streamKeyVal(bb, Dict.Key.CIDCount, maxcid + 1);
        } else {
            this.topDict.streamValue(bb, strings, Dict.Key.CIDCount);
        }
    }

    private void setPSString(CFFByteArray.CFFByteArrayBuilder bb, Integer fsType, List strings) {
        OrigFontType oft;
        String psString = null;
        if (fsType == null) {
            fsType = this.topDict.getFSType();
        }
        if (fsType != null) {
            psString = "/FSType " + fsType.toString() + " def ";
        }
        if ((oft = this.topDict.getOrigFontType()) != null) {
            psString = psString != null ? psString + " /OrigFontType /" + oft.toString() + " def" : "/OrigFontType /" + oft.toString() + " def";
        }
        if (psString != null) {
            if (strings.indexOf(psString) == -1) {
                strings.add(psString);
            }
            Dict.streamKeyVal(bb, Dict.Key.PostScript, psString, strings);
        }
    }

    private boolean checkSubrizeLimit(Subset subset) throws InvalidFontException, UnsupportedFontException {
        int cffSize = this.charStrings.data.getSize();
        if (cffSize <= 614400) {
            return true;
        }
        if (subset == null) {
            return false;
        }
        return (double)cffSize * (double)subset.getNumGlyphs() <= 614400.0 * (double)this.getNumGlyphs();
    }

    @Override
    public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS, Integer fsType) throws InvalidFontException, UnsupportedFontException, IOException {
        this.subsetAndStream(subset, out, preserveROS, fsType, false, true);
    }

    public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS, Integer fsType, boolean enableSubrizer) throws InvalidFontException, UnsupportedFontException, IOException {
        this.subsetAndStream(subset, out, preserveROS, fsType, enableSubrizer, true);
    }

    public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS, Integer fsType, boolean enableSubrizer, boolean rebuildCharstrings) throws InvalidFontException, UnsupportedFontException, IOException {
        int i;
        int charsetMarker;
        boolean doSubset = !(subset instanceof SubsetDefaultImpl) || ((SubsetDefaultImpl)subset).doSubset() || enableSubrizer;
        List strings = StringIndex.collectPredefinedStrings();
        this.topDict.collectStrings(strings);
        Dict.StringValue val = this.topDict.get(Dict.StringKey.PostScript, false);
        if (val != null) {
            strings.remove(strings.indexOf(val.value));
        }
        for (int i2 = 0; i2 < this.components.length; ++i2) {
            this.components[i2].collectStrings(strings);
        }
        CFFByteArray.CFFByteArrayBuilder bb = CFFByteArray.getCFFByteArrayBuilderInstance();
        Header.toBinary(bb);
        NameIndex.toBinary(bb, this.name);
        Index.Cursor cursor = Index.startIndex(bb, 1);
        if (preserveROS || !rebuildCharstrings) {
            this.topDict.streamValue(bb, strings, Dict.Key.ROS);
        } else {
            Dict.ROSValue ros = new Dict.ROSValue("Adobe", "Identity", 1);
            ros.collectStrings(strings);
            ros.stream(bb, strings);
            Dict.Key.ROS.stream(bb);
        }
        this.topDict.stream(bb, strings, topDictKeysForSubset);
        this.setCIDCount(preserveROS, bb, subset, doSubset, strings);
        this.setPSString(bb, fsType, strings);
        int fdArrayMarker = Dict.Key.FDArray.streamDummyValue(bb);
        int fdSelectMarker = Dict.Key.FDSelect.streamDummyValue(bb);
        int predefinedCharset = this.charset.predefinedOffset();
        if (doSubset || !preserveROS) {
            charsetMarker = Dict.Key.charset.streamDummyValue(bb);
        } else if (predefinedCharset != -1) {
            new Dict.IntegerValue(predefinedCharset).stream(bb, null);
            charsetMarker = -1;
        } else {
            charsetMarker = Dict.Key.charset.streamDummyValue(bb);
        }
        int charStringsMarker = Dict.Key.CharStrings.streamDummyValue(bb);
        cursor = Index.elementEntered(bb, cursor);
        StringIndex.toBinary(bb, strings);
        CFFSubrize subrizer = null;
        CharStrings subsetCharstrings = null;
        CharStrings gSubrStrings = null;
        if (!doSubset || !rebuildCharstrings) {
            if (this.globalSubrs != null) {
                this.globalSubrs.stream(bb);
            } else {
                bb.addCard16(0);
            }
        } else {
            if (enableSubrizer) {
                enableSubrizer = this.checkSubrizeLimit(subset);
            }
            subsetCharstrings = this.createSubsetCharstringIndex(subset, enableSubrizer);
            if (enableSubrizer) {
                byte[] fdIndex = new byte[subset.getNumGlyphs()];
                for (i = 0; i < subset.getNumGlyphs(); ++i) {
                    fdIndex[i] = (byte)this.getFDForGlyph(subset.getFullGid(i));
                }
                subrizer = new CFFSubrize();
                subsetCharstrings = subrizer.subrize(subsetCharstrings, fdIndex);
                gSubrStrings = subrizer.getGSubrs();
                if (gSubrStrings == null) {
                    gSubrStrings = CharStrings.createEmptyCharstrings();
                }
                gSubrStrings.stream(bb);
            } else {
                bb.addCard16(0);
            }
        }
        Dict.Key.FDArray.fixOffset(bb, fdArrayMarker, bb.getSize());
        int[] privateMarkers = new int[this.components.length];
        cursor = Index.startIndex(bb, this.components.length);
        for (i = 0; i < this.components.length; ++i) {
            this.components[i].fontDict.stream(bb, strings, fontDictKeysForSubset);
            privateMarkers[i] = Dict.Key.Private.streamDummyValue(bb);
            cursor = Index.elementEntered(bb, cursor);
        }
        for (i = 0; i < this.components.length; ++i) {
            CharStrings lSubrStrings = null;
            if (subrizer != null && (lSubrStrings = subrizer.getLSubrs(i)) == null) {
                lSubrStrings = CharStrings.createEmptyCharstrings();
            }
            Dict.Key.Private.fixOffset(bb, privateMarkers[i], bb.getSize());
            int start = bb.getSize();
            this.components[i].privateDict.stream(bb, strings, privateDictKeysForSubset);
            int localSubrsMarker = 0;
            if (lSubrStrings != null || (!doSubset || !rebuildCharstrings) && this.components[i].localSubrs != null) {
                localSubrsMarker = Dict.Key.Subrs.streamDummyValue(bb);
            }
            int size = bb.getSize() - start;
            Dict.Key.Private.fixSize(bb, privateMarkers[i], size);
            if (lSubrStrings == null && (doSubset && rebuildCharstrings || this.components[i].localSubrs == null)) continue;
            Dict.Key.Subrs.fixOffset(bb, localSubrsMarker, bb.getSize() - start);
            if (lSubrStrings != null) {
                lSubrStrings.stream(bb);
                continue;
            }
            this.components[i].localSubrs.stream(bb);
        }
        Dict.Key.FDSelect.fixOffset(bb, fdSelectMarker, bb.getSize());
        if (!doSubset || !rebuildCharstrings) {
            this.fdSelect.stream(bb);
        } else if (this.components.length > 1) {
            FdSelect.fdSelectFromSubset(this.fdSelect, subset).stream(bb);
        } else {
            FdSelect.singleFont(subset.getNumGlyphs()).stream(bb);
        }
        if (charsetMarker != -1) {
            Dict.Key.charset.fixOffset(bb, charsetMarker, bb.getSize());
            if (!doSubset && preserveROS || !rebuildCharstrings) {
                this.charset.stream(bb);
            } else if (!preserveROS) {
                Charset.identityCharset(subset.getNumGlyphs()).stream(bb);
            } else {
                Charset.charSetFromSubset(this.charset, subset).stream(bb);
            }
        }
        Dict.Key.CharStrings.fixOffset(bb, charStringsMarker, bb.getSize());
        if (!doSubset || !rebuildCharstrings) {
            this.charStrings.stream(bb);
        } else {
            subsetCharstrings.stream(bb);
        }
        CFFByteArray byteArray = bb.toCFFByteArray();
        byteArray.write(out);
    }

    @Override
    public PDFFontDescription getPDFFontDescription(Font font) throws UnsupportedFontException, InvalidFontException {
        return this.xdcDescription;
    }

    @Override
    public XDCFontDescription getXDCFontDescription(Font font) throws UnsupportedFontException, InvalidFontException {
        return this.xdcDescription;
    }

    @Override
    public void stream(OutputStream out, Integer fsType) throws InvalidFontException, UnsupportedFontException, IOException {
        SubsetDefaultImpl fakeSubset = new SubsetDefaultImpl(this.getNumGlyphs(), false);
        this.subsetAndStream(fakeSubset, out, true, fsType);
    }

    private class CIDKeyedFontXDCFontDescription
    extends CFFFont.CFFFontXDCFontDescription {
        private CIDKeyedFontXDCFontDescription() {
        }

        @Override
        public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException {
            CIDKeyedFont.this.subsetAndStream(subset, out, preserveROS);
        }

        @Override
        public void stream(OutputStream out, boolean openTypeOk) throws InvalidFontException, UnsupportedFontException, IOException {
            CIDKeyedFont.this.stream(out, null);
        }

        @Override
        public void subsetAndStream(SubsetSimpleType1 t1Subset, OutputStream out) throws UnsupportedFontException {
            throw new UnsupportedFontException("Not a name-keyed font");
        }

        @Override
        public void subsetAndStream(SubsetSimpleTrueType ttSubset, OutputStream out) throws UnsupportedFontException {
            throw new UnsupportedFontException("Not a TrueType font");
        }

        @Override
        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            HashSet<CodePage> codePageSet = new HashSet<CodePage>();
            ROS ros = this.getROS();
            if (ros != null && ros.registry.equals("Adobe")) {
                if (ros.ordering.equals("Japan1") || ros.ordering.equals("Japan2")) {
                    codePageSet.add(CodePage.JAPANESE);
                } else if (ros.ordering.equals("Korea1")) {
                    codePageSet.add(CodePage.KOREAN);
                } else if (ros.ordering.equals("GB1")) {
                    codePageSet.add(CodePage.SIMPLIFIED_CHINESE);
                } else if (ros.ordering.equals("CNS1")) {
                    codePageSet.add(CodePage.TRADITIONAL_CHINESE);
                }
            }
            CodePage[] retVal = new CodePage[codePageSet.size()];
            Iterator iter = codePageSet.iterator();
            int index = 0;
            while (iter.hasNext()) {
                retVal[index++] = (CodePage)iter.next();
            }
            return retVal;
        }

        @Override
        public int getCIDCount() {
            return CIDKeyedFont.this.getCIDCount();
        }
    }
}

