/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.math.Math2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class NonOverlappingOutlineConsumer
implements OutlineConsumer {
    private static final int MAX_NUM_SUBPATHS = 1000;
    private static final int MAX_NUM_SEGMENTS = 1000;
    private static final int SEG_DELETE = 1;
    private static final int SEG_ISECT = 2;
    private static final int SEG_WIND_TEST = 4;
    float cpx;
    float cpy;
    private SubPath currentSubPath;
    private List path;
    private List newPath;
    private List savedPath;
    private List isectList;
    private List segList;
    private float unitsPerEm;
    boolean selfIsectFlag;
    OutlineConsumer oc;
    int debugNumGlyphsWithOverlaps;
    int debugNumFailures;

    private static float milliem(float unitsPerEm, float v) {
        return (float)((double)(unitsPerEm * v) / 1000.0);
    }

    public NonOverlappingOutlineConsumer(OutlineConsumer oc, double upem) {
        this.oc = oc;
        this.currentSubPath = null;
        this.path = new ArrayList();
        this.segList = new ArrayList();
        this.cpx = 0.0f;
        this.cpy = 0.0f;
        this.unitsPerEm = (float)upem;
        this.debugNumGlyphsWithOverlaps = 0;
        this.debugNumFailures = 0;
    }

    private void saveIsect(Point p, Segment segment, float t, long id) {
        ListIterator iSectIter = this.isectList.listIterator();
        Point u = new Point(Math.round(p.x), Math.round(p.y));
        Intersect isect = null;
        if (!this.selfIsectFlag) {
            while (iSectIter.hasNext()) {
                float vy;
                float vx;
                isect = (Intersect)iSectIter.next();
                SubPath iSubPath = isect.seg.subPath;
                if (iSubPath != segment.subPath || !Math2.epsilonEquals(vx = (float)Math.round(isect.p.x), u.x) || !Math2.epsilonEquals(vy = (float)Math.round(isect.p.y), u.y)) continue;
                return;
            }
        }
        Intersect newISect = new Intersect(t, p, segment, null, id);
        this.isectList.add(newISect);
        segment.subPath.pathISected = true;
    }

    private void saveIsectPair(Segment seg0, float t0, Segment seg1, float t1) {
        long segLastpy;
        long segLastpx;
        long segFirstpy;
        long segFirstpx;
        Line l;
        Point p;
        long id = this.isectList.size();
        if (t0 == 0.0f) {
            p = new Point(seg0.getFirstPoint());
        } else if (t1 == 0.0f) {
            p = new Point(seg1.getFirstPoint());
        } else if (t0 == 1.0f) {
            p = new Point(seg0.getLastPoint());
        } else if (t1 == 1.0f) {
            p = new Point(seg1.getLastPoint());
        } else if (seg0 instanceof Line) {
            l = (Line)seg0;
            p = l.computeISectPoint(t0);
        } else if (seg1 instanceof Line) {
            l = (Line)seg1;
            p = l.computeISectPoint(t1);
        } else {
            Curve c = (Curve)seg0;
            p = c.computeISectPoint(t0);
        }
        long x = Math.round(p.x);
        long y = Math.round(p.y);
        if (0.0f < t0 && t0 < 1.0f) {
            segFirstpx = Math.round(seg0.getFirstPoint().x);
            segFirstpy = Math.round(seg0.getFirstPoint().y);
            segLastpx = Math.round(seg0.getLastPoint().x);
            segLastpy = Math.round(seg0.getLastPoint().y);
            if (x == segFirstpx && y == segFirstpy || x == segLastpx && y == segLastpy) {
                t0 = Math.round(t0);
            }
        }
        if (0.0f < t1 && t1 < 1.0f) {
            segFirstpx = Math.round(seg1.getFirstPoint().x);
            segFirstpy = Math.round(seg1.getFirstPoint().y);
            segLastpx = Math.round(seg1.getLastPoint().x);
            segLastpy = Math.round(seg1.getLastPoint().y);
            if (x == segFirstpx && y == segFirstpy || x == segLastpx && y == segLastpy) {
                t1 = Math.round(t1);
            }
        }
        this.saveIsect(p, seg0, t0, id);
        this.saveIsect(p, seg1, t1, id + 1L);
    }

    private void isectLineLineSegs(Segment s0, Segment s1) {
        if (!(s0 instanceof Line)) {
            return;
        }
        Line l0 = (Line)s0;
        if (!(s1 instanceof Line)) {
            return;
        }
        Line l1 = (Line)s1;
        List iSects = l0.iSectLine(l1);
        if (iSects.size() == 2) {
            float[] t = (float[])iSects.get(1);
            this.saveIsectPair(s0, t[0], s1, t[1]);
            t = (float[])iSects.get(0);
            this.saveIsectPair(s0, t[0], s1, t[1]);
        } else if (iSects.size() == 1) {
            float[] t = (float[])iSects.get(0);
            this.saveIsectPair(s0, t[0], s1, t[1]);
        }
    }

    private void isectLineCurveSegs(Segment s0, Segment s1) {
        if (!(s0 instanceof Line)) {
            return;
        }
        Line l = (Line)s0;
        if (!(s1 instanceof Curve)) {
            return;
        }
        Curve c = (Curve)s1;
        while (true) {
            if (c.isFlatEnough(this.unitsPerEm)) {
                Line newLine = c.makeLine();
                List iSects = newLine.iSectLine(l);
                if (iSects.size() == 2) {
                    float[] t = (float[])iSects.get(1);
                    this.saveIsectPair(s1.origSeg, c.t0 + t[0] * (c.t1 - c.t0), s0.origSeg, l.t0 + t[1] * (l.t1 - l.t0));
                    t = (float[])iSects.get(0);
                    this.saveIsectPair(s1.origSeg, c.t0 + t[0] * (c.t1 - c.t0), s0.origSeg, l.t0 + t[1] * (l.t1 - l.t0));
                    return;
                }
                if (iSects.size() == 1) {
                    float[] t = (float[])iSects.get(0);
                    this.saveIsectPair(s1.origSeg, c.t0 + t[0] * (c.t1 - c.t0), s0.origSeg, l.t0 + t[1] * (l.t1 - l.t0));
                    return;
                }
                return;
            }
            if (!l.iSectRect(c.getBounds())) break;
            List curves = c.splitMid();
            Curve b = (Curve)curves.get(0);
            c = (Curve)curves.get(1);
            this.isectLineCurveSegs(l, b);
        }
    }

    private void isectCurveCurve(Curve a, Curve b) {
        if (!a.getBounds().overlap(b.getBounds())) {
            return;
        }
        if (a.isFlatEnough(this.unitsPerEm)) {
            Line l = a.makeLine();
            this.isectLineCurveSegs(l, b);
        } else {
            List curves = a.splitMid();
            Curve c = (Curve)curves.get(0);
            a = (Curve)curves.get(1);
            this.isectCurveCurve(b, c);
            this.isectCurveCurve(b, a);
        }
    }

    private void isectCurveCurveSegs(Segment s0, Segment s1) {
        if (!(s0 instanceof Curve)) {
            return;
        }
        Curve c0 = (Curve)s0;
        if (!(s1 instanceof Curve)) {
            return;
        }
        Curve c1 = (Curve)s1;
        if (c0.equalControlPoints(c1)) {
            this.saveIsectPair(s0, 0.0f, s1, 0.0f);
            this.saveIsectPair(s0, 1.0f, s1, 1.0f);
        } else if (c0.reverseControlPoints(c1)) {
            this.saveIsectPair(s0, 0.0f, s1, 1.0f);
            this.saveIsectPair(s0, 1.0f, s1, 0.0f);
        } else {
            this.isectCurveCurve(c0, c1);
        }
    }

    private void isectSegPair(Segment s0, Segment s1) {
        s0.origSeg = s0;
        s1.origSeg = s1;
        if (s0 instanceof Line) {
            if (s1 instanceof Line) {
                this.isectLineLineSegs(s0, s1);
            } else {
                this.isectLineCurveSegs(s0, s1);
            }
        } else if (s1 instanceof Line) {
            this.isectLineCurveSegs(s1, s0);
        } else {
            this.isectCurveCurveSegs(s0, s1);
        }
    }

    private void isectPathPair(SubPath p0, SubPath p1) {
        Segment s0 = p0.firstSegment;
        if (s0 == null) {
            return;
        }
        do {
            Segment s1;
            if ((s1 = p1.firstSegment) == null) {
                return;
            }
            do {
                if (!s0.getBounds().overlap(s1.getBounds())) continue;
                this.isectSegPair(s0, s1);
            } while ((s1 = s1.nextSeg()) != p1.firstSegment);
        } while ((s0 = s0.nextSeg()) != p0.firstSegment);
    }

    private void splitSegment(Intersect last, Intersect isect) {
        Segment newSeg;
        float t = isect.t;
        Segment seg = isect.seg;
        if (last != null && last.seg == isect.seg) {
            if (t == last.t || t == 1.0f) {
                isect.splitSeg = last.splitSeg;
                return;
            }
            if (last.splitSeg != null) {
                t = (t - last.t) / (1.0f - last.t);
                seg = last.splitSeg;
            }
        } else if (t == 0.0f || t == 1.0f) {
            return;
        }
        if (seg instanceof Line) {
            Line l = (Line)seg;
            Line newl = new Line(isect.p, l.p1);
            l.p1.x = isect.p.x;
            l.p1.y = isect.p.y;
            newSeg = newl;
        } else {
            Curve c = (Curve)seg;
            Point p0 = new Point(c.p0);
            Point p1 = new Point(c.p1);
            Point p2 = new Point(c.p2);
            Point p3 = new Point(c.p3);
            c.p1.x = Math.round(t * (p1.x - p0.x) + c.p0.x);
            c.p1.y = Math.round(t * (p1.y - p0.y) + c.p0.y);
            c.p2.x = Math.round(t * t * (p2.x - 2.0f * p1.x + p0.x) + 2.0f * c.p1.x - c.p0.x);
            c.p2.y = Math.round(t * t * (p2.y - 2.0f * p1.y + p0.y) + 2.0f * c.p1.y - c.p0.y);
            c.p3.x = Math.round(isect.p.x);
            c.p3.y = Math.round(isect.p.y);
            if (c.isLine(this.unitsPerEm)) {
                Line l = c.makeLine();
                seg.subPath.replaceSegment(seg, l);
            }
            t = 1.0f - t;
            Point newp3 = new Point(p3);
            Point newp2 = new Point(Math.round(t * (p2.x - p3.x) + newp3.x), Math.round(t * (p2.y - p3.y) + newp3.y));
            Point newp1 = new Point(Math.round(t * t * (p1.x - 2.0f * p2.x + p3.x) + 2.0f * newp2.x - newp3.x), Math.round(t * t * (p1.y - 2.0f * p2.y + p3.y) + 2.0f * newp2.y - newp3.y));
            Point newp0 = new Point(c.p3);
            Curve newc = new Curve(newp0, newp1, newp2, newp3);
            newSeg = newc;
            if (newc.isLine(this.unitsPerEm)) {
                Line l;
                newSeg = l = newc.makeLine();
            }
        }
        SubPath sp = seg.subPath;
        sp.splitSegment(seg, newSeg);
        isect.splitSeg = newSeg;
    }

    private void splitIsectSegs() {
        SegComparator segCompare = new SegComparator();
        Collections.sort(this.isectList, segCompare);
        Intersect last = null;
        for (Intersect isect : this.isectList) {
            this.splitSegment(last, isect);
            last = isect;
        }
        Object[] isectArray = this.isectList.toArray();
        for (int i = isectArray.length - 1; i > 0; --i) {
            last = (Intersect)isectArray[i - 1];
            Intersect isect = (Intersect)isectArray[i];
            if (isect.splitSeg == null || last == null || last.seg != isect.seg || last.splitSeg == null) continue;
            isect.seg = last.splitSeg;
            isect.splitSeg = isect.seg.nextSeg();
        }
        for (Intersect isect : this.isectList) {
            Segment seg = isect.seg;
            if (isect.splitSeg == null) {
                isect.splitSeg = isect.t == 0.0f ? seg.prevSeg() : seg.nextSeg();
            } else {
                seg.round(this.unitsPerEm);
                isect.splitSeg.round(this.unitsPerEm);
            }
            seg.flags |= 2;
            isect.splitSeg.flags |= 2;
        }
    }

    private void windTestSeg(Segment target) {
        Point p = new Point();
        if ((target.flags & 5) != 0) {
            return;
        }
        if (target instanceof Line) {
            Line l = (Line)target;
            p.x = (l.p0.x + l.p1.x) / 2.0f;
            p.y = (l.p0.y + l.p1.y) / 2.0f;
        } else {
            Curve c = (Curve)target;
            p.x = (c.p3.x + 3.0f * (c.p2.x + c.p1.x) + c.p0.x) / 8.0f;
            p.y = (c.p3.y + 3.0f * (c.p2.y + c.p1.y) + c.p0.y) / 8.0f;
        }
        int windtotal = 0;
        boolean testvert = target.horizontal();
        int windtarget = testvert ? target.getWindingX() : target.getWindingY();
        SubPath sp = target.subPath;
        do {
            if (testvert) {
                if (sp.bounds.top < p.y || sp.bounds.left > p.x || sp.bounds.right <= p.x) {
                    sp = sp.nextSubPath;
                    continue;
                }
            } else if (sp.bounds.left > p.x || sp.bounds.bottom > p.y || sp.bounds.top <= p.y) {
                sp = sp.nextSubPath;
                continue;
            }
            Segment seg = sp.firstSegment;
            do {
                List iceptList;
                Rect segBounds;
                if (seg == target) continue;
                if (testvert) {
                    segBounds = seg.getBounds();
                    if (segBounds.top < p.y || segBounds.left > p.x || segBounds.right <= p.x || segBounds.left == segBounds.right) continue;
                    if (segBounds.bottom > p.y) {
                        windtotal += Segment.getWindingAtValue(seg.getFirstPoint().x, seg.getLastPoint().x, p.x);
                        continue;
                    }
                    if (seg.reverseControlPoints(target)) {
                        target.flags |= 5;
                        return;
                    }
                    if (seg.equalControlPoints(target)) {
                        if (this.path.indexOf(seg.subPath) < this.path.indexOf(target.subPath)) {
                            target.flags |= 1;
                        }
                        target.flags |= 4;
                        return;
                    }
                    iceptList = seg.solveAtX(p.x);
                    for (ICept icept : iceptList) {
                        if (!(icept.ic > p.y)) continue;
                        windtotal += icept.winding;
                    }
                } else {
                    segBounds = seg.getBounds();
                    if (segBounds.left > p.x || segBounds.bottom > p.y || segBounds.top <= p.y || segBounds.top == segBounds.bottom) continue;
                    if (segBounds.right < p.x) {
                        windtotal += Segment.getWindingAtValue(seg.getFirstPoint().y, seg.getLastPoint().y, p.y);
                        continue;
                    }
                    if (seg.reverseControlPoints(target)) {
                        target.flags |= 5;
                        return;
                    }
                    if (seg.equalControlPoints(target)) {
                        if (this.path.indexOf(seg.subPath) < this.path.indexOf(target.subPath)) {
                            target.flags |= 1;
                        }
                        target.flags |= 4;
                        return;
                    }
                    iceptList = seg.solveAtY(p.y);
                    for (ICept icept : iceptList) {
                        if (!(icept.ic < p.x)) continue;
                        windtotal += icept.winding;
                    }
                }
            } while ((seg = seg.nextSeg()) != sp.firstSegment);
            sp = sp.nextSubPath;
        } while (sp != target.subPath);
        if (windtotal != 0 && windtotal + windtarget != 0) {
            target.flags |= 1;
        }
        target.flags |= 4;
    }

    private void deleteBadSegs() throws ISectException {
        if (this.isectList.size() % 2 != 0) {
            throw new ISectException("error - uneven intersects");
        }
        IDComparator idCompare = new IDComparator();
        Collections.sort(this.isectList, idCompare);
        for (Intersect isect : this.isectList) {
            this.windTestSeg(isect.seg);
            this.windTestSeg(isect.splitSeg);
        }
        Iterator iter = this.isectList.iterator();
        while (iter.hasNext()) {
            Segment bend;
            Segment bbeg;
            Segment aend;
            Segment abeg;
            Intersect a = (Intersect)iter.next();
            Intersect b = (Intersect)iter.next();
            if (a.seg.nextSeg() == a.splitSeg) {
                abeg = a.seg;
                aend = a.splitSeg;
            } else {
                abeg = a.splitSeg;
                aend = a.seg;
            }
            if (b.seg.nextSeg() == b.splitSeg) {
                bbeg = b.seg;
                bend = b.splitSeg;
            } else {
                bbeg = b.splitSeg;
                bend = b.seg;
            }
            switch ((abeg.flags & 1) << 3 | (aend.flags & 1) << 2 | (bbeg.flags & 1) << 1 | (bend.flags & 1) << 0) {
                case 0: 
                case 3: 
                case 12: 
                case 15: {
                    break;
                }
                case 5: 
                case 10: {
                    throw new ISectException("error - illegal segment flags");
                }
                case 1: {
                    abeg.flags |= 1;
                    bbeg.relink(aend);
                    break;
                }
                case 2: {
                    aend.flags |= 1;
                    abeg.relink(bend);
                    break;
                }
                case 4: {
                    bbeg.flags |= 1;
                    abeg.relink(bend);
                    break;
                }
                case 6: {
                    abeg.relink(bend);
                    break;
                }
                case 7: {
                    if (!abeg.getLastPoint().equals(bend.getFirstPoint())) break;
                    bend.flags &= 0xFFFFFFFE;
                    abeg.relink(bend);
                    break;
                }
                case 8: {
                    bend.flags |= 1;
                    bbeg.relink(aend);
                    break;
                }
                case 9: {
                    bbeg.relink(aend);
                    break;
                }
                case 11: {
                    if (!bbeg.getLastPoint().equals(aend.getFirstPoint())) break;
                    bbeg.flags &= 0xFFFFFFFE;
                    bbeg.relink(aend);
                    break;
                }
                case 13: {
                    if (!bbeg.getLastPoint().equals(aend.getFirstPoint())) break;
                    aend.flags &= 0xFFFFFFFE;
                    bbeg.relink(aend);
                    break;
                }
                case 14: {
                    if (!abeg.getLastPoint().equals(bend.getFirstPoint())) break;
                    abeg.flags &= 0xFFFFFFFE;
                    abeg.relink(bend);
                }
            }
        }
    }

    private SubPath newSubPath(Segment seg) throws ISectException {
        SubPath sp = new SubPath();
        sp.addSegments(seg);
        return sp;
    }

    private void buildSubPath(Segment seg) throws ISectException {
        if ((seg.flags & 1) != 0 || this.newPath.contains(seg.subPath)) {
            return;
        }
        SubPath subPath = this.newSubPath(seg);
        this.addPath(this.newPath, subPath);
    }

    private void buildNewPaths() throws ISectException {
        this.newPath = new ArrayList();
        for (SubPath sp : this.path) {
            if (sp.pathISected) continue;
            this.addPath(this.newPath, sp);
        }
        for (Intersect isect : this.isectList) {
            this.buildSubPath(isect.seg);
            this.buildSubPath(isect.splitSeg);
        }
        for (SubPath sp : this.path) {
            if (!sp.pathISected) continue;
            Segment seg = sp.firstSegment;
            SubPath segsp = seg.subPath;
            if (!this.newPath.contains(segsp) || (seg.flags & 1) == 1) continue;
            segsp.firstSegment = seg;
            segsp.lastSegment = seg.prevSegment;
        }
        for (SubPath sp : this.newPath) {
            int lastdir = 0;
            int segcnt = 0;
            Segment seg = sp.firstSegment;
            do {
                int thisdir = 0;
                if (seg instanceof Line) {
                    Line l = (Line)seg;
                    if (Math2.epsilonEquals(l.p0.x, l.p1.x)) {
                        thisdir = 1;
                    } else if (Math2.epsilonEquals(l.p0.y, l.p1.y)) {
                        thisdir = -1;
                    } else {
                        if (++segcnt > this.segList.size()) {
                            throw new ISectException("Infinite loop condition!");
                        }
                        lastdir = thisdir;
                        seg = seg.nextSeg();
                        continue;
                    }
                    if (seg != sp.firstSegment && thisdir == lastdir) {
                        Point p = new Point(l.p1);
                        Segment lastSeg = seg.prevSegment;
                        sp.removeSegment(seg);
                        if (lastSeg instanceof Line) {
                            Line ll = (Line)lastSeg;
                            ll.p1 = p;
                            ll.setBounds();
                        } else {
                            Curve c = (Curve)lastSeg;
                            c.p3 = p;
                            c.setBounds();
                        }
                    }
                    if (++segcnt > this.segList.size()) {
                        throw new ISectException("Infinite loop condition!");
                    }
                }
                lastdir = thisdir;
                seg = seg.nextSeg();
            } while (seg != sp.firstSegment);
        }
    }

    private void selfIsectPath(SubPath subPath) throws ISectException {
        if (subPath.getNumSegments() > 1000) {
            throw new ISectException("error - too many segments in subpath");
        }
        if (subPath.getNumSegments() < 3) {
            return;
        }
        Segment s0 = subPath.firstSegment;
        while (s0.nextSeg() != subPath.lastSegment) {
            Segment s1 = s0.nextSeg();
            do {
                if ((s1 = s1.nextSeg()).nextSeg() == s0 || !s0.getBounds().overlap(s1.getBounds())) continue;
                this.isectSegPair(s0, s1);
            } while (s1 != subPath.lastSegment);
            s0 = s0.nextSeg();
        }
    }

    private void isectPath() throws ISectException {
        List subPathList = this.path;
        if (subPathList == null) {
            return;
        }
        if (subPathList.size() > 1000) {
            throw new ISectException("error - too many subpaths");
        }
        this.isectList = new ArrayList();
        Iterator subPathListIter = subPathList.iterator();
        this.selfIsectFlag = true;
        while (subPathListIter.hasNext()) {
            SubPath subPath = (SubPath)subPathListIter.next();
            this.selfIsectPath(subPath);
        }
        this.selfIsectFlag = false;
        Object[] subPathArray = subPathList.toArray();
        for (int i = 0; i < subPathArray.length; ++i) {
            SubPath subPathi = (SubPath)subPathArray[i];
            for (int j = i + 1; j < subPathArray.length; ++j) {
                SubPath subPathj = (SubPath)subPathArray[j];
                if (!subPathj.bounds.overlap(subPathi.bounds)) continue;
                this.isectPathPair(subPathi, subPathj);
            }
        }
        if (this.isectList.size() > 0) {
            this.savedPath = this.copyPath(this.path);
            this.splitIsectSegs();
            this.deleteBadSegs();
            this.buildNewPaths();
            ++this.debugNumGlyphsWithOverlaps;
        } else {
            this.newPath = this.path;
        }
    }

    private void addPath(List pathList, SubPath subPath) {
        int size = pathList.size();
        if (size > 0) {
            SubPath lastsp = (SubPath)pathList.get(size - 1);
            subPath.nextSubPath = lastsp.nextSubPath;
            lastsp.nextSubPath = subPath;
        } else {
            subPath.nextSubPath = subPath;
        }
        pathList.add(subPath);
    }

    private List copyPath(List pathList) throws ISectException {
        ArrayList<SubPath> copiedPathList = new ArrayList<SubPath>();
        for (SubPath sp : pathList) {
            SubPath newsp = new SubPath();
            newsp.copySubPath(sp);
            copiedPathList.add(newsp);
        }
        return copiedPathList;
    }

    private void generateOutline(List path) {
        if (path == null) {
            return;
        }
        Iterator pathListIter = path.iterator();
        if (this.savedPath != null) {
            boolean foundLoopInPath = false;
            int maxNumSegments = this.segList.size();
            while (pathListIter.hasNext() && !foundLoopInPath) {
                SubPath subPath = (SubPath)pathListIter.next();
                if (subPath == null) continue;
                Segment pathSegment = subPath.firstSegment;
                if (pathSegment == null) {
                    return;
                }
                int i = 0;
                do {
                    if (++i <= maxNumSegments) continue;
                    path = this.savedPath;
                    foundLoopInPath = true;
                } while ((pathSegment = pathSegment.nextSeg()) != subPath.firstSegment && !foundLoopInPath);
            }
        }
        for (SubPath subPath : path) {
            if (subPath == null) continue;
            Segment pathSegment = subPath.firstSegment;
            if (pathSegment == null) {
                return;
            }
            boolean move = true;
            do {
                if (pathSegment instanceof Line) {
                    Line l = (Line)pathSegment;
                    if (move) {
                        this.oc.moveto(l.p0.x, l.p0.y);
                        move = false;
                    }
                    if (pathSegment == subPath.lastSegment) continue;
                    this.oc.lineto(l.p1.x, l.p1.y);
                    continue;
                }
                if (!(pathSegment instanceof Curve)) continue;
                Curve c = (Curve)pathSegment;
                if (move) {
                    this.oc.moveto(c.p0.x, c.p0.y);
                    move = false;
                }
                this.oc.curveto(c.p1.x, c.p1.y, c.p2.x, c.p2.y, c.p3.x, c.p3.y);
            } while ((pathSegment = pathSegment.nextSeg()) != subPath.firstSegment);
        }
    }

    @Override
    public void setMatrix(Matrix newMatrix) {
        this.oc.setMatrix(newMatrix);
    }

    @Override
    public void moveto(double x, double y) {
        if (this.currentSubPath != null && this.currentSubPath.getNumSegments() > 0) {
            this.currentSubPath.closepath(this.cpx, this.cpy);
            this.addPath(this.path, this.currentSubPath);
        }
        this.currentSubPath = new SubPath((float)x, (float)y);
        this.cpx = (float)x;
        this.cpy = (float)y;
    }

    @Override
    public void lineto(double x, double y) {
        if (x == (double)this.cpx && y == (double)this.cpy) {
            return;
        }
        if (this.currentSubPath == null) {
            this.moveto(0.0, 0.0);
        }
        Line l = new Line(this.cpx, this.cpy, (float)x, (float)y);
        this.currentSubPath.addSegment(l, true);
        this.cpx = (float)x;
        this.cpy = (float)y;
    }

    @Override
    public void curveto(double x1, double y1, double x2, double y2) {
        this.curveto(Math.round(((double)this.cpx + 2.0 * x1) / 3.0), Math.round(((double)this.cpy + 2.0 * y1) / 3.0), Math.round((2.0 * x1 + x2) / 3.0), Math.round((2.0 * y1 + y2) / 3.0), Math.round(x2), Math.round(y2));
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3, double x4, double y4) {
        if (this.currentSubPath == null) {
            this.moveto(0.0, 0.0);
        }
        Curve c = new Curve(this.cpx, this.cpy, (float)x2, (float)y2, (float)x3, (float)y3, (float)x4, (float)y4);
        this.currentSubPath.addSegment(c, true);
        this.cpx = (float)x4;
        this.cpy = (float)y4;
    }

    public void reset() {
        this.currentSubPath = null;
        this.path.clear();
        this.savedPath = null;
        this.newPath = null;
        this.isectList = null;
        this.segList.clear();
        this.cpx = 0.0f;
        this.cpy = 0.0f;
    }

    @Override
    public void endchar() {
        if (this.currentSubPath != null && this.currentSubPath.getNumSegments() > 0) {
            this.currentSubPath.closepath(this.cpx, this.cpy);
            this.addPath(this.path, this.currentSubPath);
        }
        try {
            this.isectPath();
        }
        catch (ISectException e) {
            ++this.debugNumFailures;
            this.newPath = this.savedPath;
        }
        this.generateOutline(this.newPath);
        this.oc.endchar();
        this.reset();
    }

    public int getNumErrors() {
        return this.debugNumFailures;
    }

    private class SubPath {
        Rect bounds;
        Point startPoint;
        boolean pathISected;
        Segment firstSegment;
        Segment lastSegment;
        int numSegments;
        SubPath nextSubPath;

        SubPath() {
            this.bounds = new Rect(0.0f, 0.0f, 0.0f, 0.0f);
            this.startPoint = null;
            this.firstSegment = null;
            this.lastSegment = null;
            this.numSegments = 0;
            this.nextSubPath = null;
            this.pathISected = false;
        }

        SubPath(float x, float y) {
            this.bounds = new Rect(x, y, x, y);
            this.startPoint = new Point(x, y);
            this.firstSegment = null;
            this.lastSegment = null;
            this.numSegments = 0;
            this.nextSubPath = null;
            this.pathISected = false;
        }

        public String toString() {
            String str = "Num Segments:" + this.numSegments;
            if (this.numSegments == 0) {
                return str;
            }
            Segment s = this.firstSegment;
            do {
                str = str + s.toString() + "\n";
            } while ((s = s.nextSeg()) != this.firstSegment);
            return str;
        }

        private int getNumSegments() {
            return this.numSegments;
        }

        private void addSegment(Segment s, boolean addToSegList) {
            if (addToSegList) {
                NonOverlappingOutlineConsumer.this.segList.add(s);
            }
            s.subPath = this;
            if (this.lastSegment == null) {
                this.firstSegment = s;
                this.lastSegment = s;
                s.link(s);
            } else {
                this.lastSegment.link(s);
                this.lastSegment = s;
            }
            this.bounds.grow(s.getBounds());
            ++this.numSegments;
        }

        private void copySubPath(SubPath sp) throws ISectException {
            Segment n = sp.firstSegment;
            if (sp.firstSegment.subPath == this) {
                return;
            }
            int totalNumSegments = NonOverlappingOutlineConsumer.this.segList.size();
            do {
                Segment newseg = n.copySegment();
                n = n.nextSeg();
                this.addSegment(newseg, true);
                if (this.numSegments <= totalNumSegments) continue;
                throw new ISectException("error - infinite loop");
            } while (n != sp.firstSegment);
        }

        private void addSegments(Segment s) throws ISectException {
            int totalNumSegments = NonOverlappingOutlineConsumer.this.segList.size();
            if (s.subPath == this) {
                return;
            }
            Segment n = s;
            do {
                n = s.nextSeg();
                this.addSegment(s, false);
                if (this.numSegments > totalNumSegments) {
                    throw new ISectException("error - infinite loop");
                }
                s = n;
            } while (s.subPath != this);
        }

        private void splitSegment(Segment seg, Segment newSeg) {
            NonOverlappingOutlineConsumer.this.segList.add(newSeg);
            newSeg.subPath = this;
            seg.link(newSeg);
            ++this.numSegments;
        }

        private void replaceSegment(Segment seg, Segment newSeg) {
            NonOverlappingOutlineConsumer.this.segList.add(newSeg);
            newSeg.subPath = this;
            seg.replace(newSeg);
        }

        private void removeSegment(Segment seg) throws ISectException {
            if (seg.subPath == this) {
                if (this.numSegments == 1) {
                    if (this.firstSegment == seg) {
                        this.firstSegment = null;
                        this.lastSegment = null;
                    } else {
                        throw new ISectException("error - cant handle");
                    }
                }
                if (seg == this.firstSegment) {
                    this.firstSegment = seg.nextSeg();
                }
                if (seg == this.lastSegment) {
                    this.lastSegment = seg.prevSeg();
                }
                seg.remove();
                --this.numSegments;
            }
        }

        private void closepath(float cpx, float cpy) {
            if (Math2.epsilonEquals(this.startPoint.x, cpx) && Math2.epsilonEquals(this.startPoint.y, cpy)) {
                return;
            }
            Point lastPnt = new Point(cpx, cpy);
            Line l = new Line(lastPnt, this.startPoint);
            this.addSegment(l, true);
        }
    }

    private class Intersect {
        float t;
        Point p;
        Segment seg;
        Segment splitSeg;
        long id;

        Intersect(float t, Point p, Segment seg, Segment splitSeg, long id) {
            this.p = p;
            this.t = t;
            this.seg = seg;
            this.splitSeg = splitSeg;
            this.id = id;
        }

        public String toString() {
            String s = "Isect point:" + this.p.toString() + ") t: " + this.t + "\n";
            if (this.seg != null) {
                s = s + "Segment:" + this.seg.toString() + "\n";
            }
            if (this.splitSeg != null) {
                s = s + "Split Segment:" + this.splitSeg.toString() + "\n";
            }
            return s;
        }

        private int cmpIds(Intersect i2) {
            if (this.id < i2.id) {
                return -1;
            }
            if (this.id > i2.id) {
                return 1;
            }
            return 0;
        }

        private int cmpSegs(Intersect i2) {
            int i2Seg;
            int iSeg = NonOverlappingOutlineConsumer.this.segList.indexOf(this.seg);
            if (iSeg < (i2Seg = NonOverlappingOutlineConsumer.this.segList.indexOf(i2.seg))) {
                return -1;
            }
            if (iSeg > i2Seg) {
                return 1;
            }
            if (this.t < i2.t) {
                return -1;
            }
            if (this.t > i2.t) {
                return 1;
            }
            return 0;
        }
    }

    private static class IDComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private IDComparator() {
        }

        public int compare(Object o1, Object o2) {
            Intersect i1 = (Intersect)o1;
            Intersect i2 = (Intersect)o2;
            return i1.cmpIds(i2);
        }

        boolean equals(Object o1, Object o2) {
            Intersect i1 = (Intersect)o1;
            Intersect i2 = (Intersect)o2;
            return i1.cmpIds(i2) == 0;
        }
    }

    private static class SegComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SegComparator() {
        }

        public int compare(Object o1, Object o2) {
            Intersect i1 = (Intersect)o1;
            Intersect i2 = (Intersect)o2;
            return i1.cmpSegs(i2);
        }

        boolean equals(Object o1, Object o2) {
            Intersect i1 = (Intersect)o1;
            Intersect i2 = (Intersect)o2;
            return i1.cmpSegs(i2) == 0;
        }
    }

    private static abstract class Segment {
        SubPath subPath;
        int flags;
        Segment nextSegment;
        Segment prevSegment;
        Segment origSeg;

        private Segment() {
        }

        abstract Rect getBounds();

        abstract void setBounds();

        abstract Point getLastPoint();

        abstract Point getFirstPoint();

        abstract int getID();

        abstract void roundControlPoints(float var1);

        abstract boolean horizontal();

        abstract int getWindingX();

        abstract int getWindingY();

        abstract boolean equalControlPoints(Segment var1);

        abstract boolean reverseControlPoints(Segment var1);

        abstract Segment copySegment();

        abstract List solveAtX(float var1);

        abstract List solveAtY(float var1);

        public abstract String toString();

        private Segment nextSeg() {
            return this.nextSegment;
        }

        private Segment prevSeg() {
            return this.prevSegment;
        }

        private void link(Segment nextSeg) {
            if (nextSeg == this) {
                this.nextSegment = this;
                this.prevSegment = this;
            } else {
                nextSeg.nextSegment = this.nextSegment;
                this.nextSegment.prevSegment = nextSeg;
                nextSeg.prevSegment = this;
                this.nextSegment = nextSeg;
            }
        }

        private void relink(Segment nextSeg) {
            this.nextSegment = nextSeg;
            nextSeg.prevSegment = this;
        }

        private void replace(Segment newSeg) {
            newSeg.nextSegment = this.nextSegment;
            newSeg.prevSegment = this.prevSegment;
        }

        private void remove() {
            this.prevSegment.nextSegment = this.nextSegment;
            this.nextSegment.prevSegment = this.prevSegment;
        }

        private void round(float unitsPerEm) {
            this.roundControlPoints(unitsPerEm);
            this.setBounds();
        }

        static int getWinding(float beg, float end) {
            return beg > end ? 1 : -1;
        }

        static int getWindingAtValue(float beg, float end, float value) {
            if (value < beg && value < end || value > beg && value > end) {
                return 0;
            }
            return beg > end ? 1 : -1;
        }
    }

    private static class Curve
    extends Segment {
        Point p0;
        Point p1;
        Point p2;
        Point p3;
        float t0;
        float t1;
        long depth;
        Rect bounds;
        int id;

        Curve(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
            this.p0 = new Point(x0, y0);
            this.p1 = new Point(x1, y1);
            this.p2 = new Point(x2, y2);
            this.p3 = new Point(x3, y3);
            this.t0 = 0.0f;
            this.t1 = 1.0f;
            this.depth = 0L;
            this.setBounds();
        }

        Curve(Point pnt0, Point pnt1, Point pnt2, Point pnt3) {
            this.p0 = new Point(pnt0);
            this.p1 = new Point(pnt1);
            this.p2 = new Point(pnt2);
            this.p3 = new Point(pnt3);
            this.t0 = 0.0f;
            this.t1 = 1.0f;
            this.depth = 0L;
            this.setBounds();
        }

        @Override
        public String toString() {
            String flagStr = (this.flags & 1) != 0 ? "Delete," : "";
            flagStr = (this.flags & 4) != 0 ? flagStr + " WindTested" : flagStr;
            String s = "Point p0:" + this.p0.toString() + " Point p1:" + this.p1.toString() + "Point p2:" + this.p2.toString() + " Point p3:" + this.p3.toString() + "t0:" + this.t0 + " t1:" + this.t1 + "flag:" + flagStr + " bounds:" + this.bounds.toString();
            return s;
        }

        @Override
        int getID() {
            return this.id;
        }

        private Limit getBezLimit(float p0, float p1, float p2, float p3, float min, float max) {
            float[] t = new float[2];
            int i = 0;
            float a = p3 - 3.0f * (p2 - p1) - p0;
            float b = p2 - 2.0f * p1 + p0;
            float c = p1 - p0;
            float minimum = min;
            float maximum = max;
            if (a == 0.0f) {
                if (b != 0.0f) {
                    t[i++] = -c / (2.0f * b);
                }
            } else {
                float r = b * b - a * c;
                if (r >= 0.0f) {
                    r = (float)Math.sqrt(r);
                    t[i++] = (-b + r) / a;
                    t[i++] = (-b - r) / a;
                }
            }
            --i;
            while (i >= 0) {
                if (t[i] > 0.0f && t[i] < 1.0f) {
                    float limit = t[i] * (t[i] * (t[i] * a + 3.0f * b) + 3.0f * c) + p0;
                    if (limit < min) {
                        minimum = limit;
                    } else if (limit > max) {
                        maximum = limit;
                    }
                }
                --i;
            }
            Limit l = new Limit(minimum, maximum);
            return l;
        }

        @Override
        Point getFirstPoint() {
            return this.p0;
        }

        @Override
        Point getLastPoint() {
            return this.p3;
        }

        @Override
        boolean horizontal() {
            return Math.abs(this.p3.x - this.p0.x) > Math.abs(this.p3.y - this.p0.y);
        }

        @Override
        boolean equalControlPoints(Segment s) {
            if (s instanceof Curve) {
                Curve c = (Curve)s;
                return Math2.epsilonEquals(this.p0.x, c.p0.x) && Math2.epsilonEquals(this.p0.y, c.p0.y) && Math2.epsilonEquals(this.p1.x, c.p1.x) && Math2.epsilonEquals(this.p1.y, c.p1.y) && Math2.epsilonEquals(this.p2.x, c.p2.x) && Math2.epsilonEquals(this.p2.y, c.p2.y) && Math2.epsilonEquals(this.p3.x, c.p3.x) && Math2.epsilonEquals(this.p3.y, c.p3.y);
            }
            return false;
        }

        @Override
        boolean reverseControlPoints(Segment s) {
            if (s instanceof Curve) {
                Curve c = (Curve)s;
                return Math2.epsilonEquals(this.p0.x, c.p3.x) && Math2.epsilonEquals(this.p0.y, c.p3.y) && Math2.epsilonEquals(this.p1.x, c.p2.x) && Math2.epsilonEquals(this.p1.y, c.p2.y) && Math2.epsilonEquals(this.p2.x, c.p1.x) && Math2.epsilonEquals(this.p2.y, c.p1.y) && Math2.epsilonEquals(this.p3.x, c.p0.x) && Math2.epsilonEquals(this.p3.y, c.p0.y);
            }
            return false;
        }

        @Override
        Segment copySegment() {
            Curve newc = new Curve(this.p0, this.p1, this.p2, this.p3);
            newc.t0 = this.t0;
            newc.t1 = this.t1;
            newc.id = this.id;
            newc.flags = this.flags;
            newc.origSeg = this.origSeg;
            return newc;
        }

        @Override
        void roundControlPoints(float unitsPerEm) {
            this.p0.x = Math.round(this.p0.x);
            this.p0.y = Math.round(this.p0.y);
            this.p1.x = Math.round(this.p1.x);
            this.p1.y = Math.round(this.p1.y);
            this.p2.x = Math.round(this.p2.x);
            this.p2.y = Math.round(this.p2.y);
            this.p3.x = Math.round(this.p3.x);
            this.p3.y = Math.round(this.p3.y);
            if (this.isLine(unitsPerEm)) {
                this.makeLine();
            }
        }

        @Override
        void setBounds() {
            Limit lim;
            Line l = new Line(this.p0, this.p3);
            Rect r = l.getBounds();
            if (this.p1.x < r.left || this.p1.x > r.right || this.p2.x < r.left || this.p2.x > r.right) {
                lim = this.getBezLimit(this.p0.x, this.p1.x, this.p2.x, this.p3.x, r.left, r.right);
                r.left = lim.min;
                r.right = lim.max;
            }
            if (this.p1.y < r.bottom || this.p1.y > r.top || this.p2.y < r.bottom || this.p2.y > r.top) {
                lim = this.getBezLimit(this.p0.y, this.p1.y, this.p2.y, this.p3.y, r.bottom, r.top);
                r.bottom = lim.min;
                r.top = lim.max;
            }
            this.bounds = r;
        }

        @Override
        Rect getBounds() {
            if (this.bounds != null) {
                return this.bounds;
            }
            this.setBounds();
            return this.bounds;
        }

        private Point computeISectPoint(float t) {
            float x = t * (t * (t * (this.p3.x - 3.0f * (this.p2.x - this.p1.x) - this.p0.x) + 3.0f * (this.p2.x - 2.0f * this.p1.x + this.p0.x)) + 3.0f * (this.p1.x - this.p0.x)) + this.p0.x;
            float y = t * (t * (t * (this.p3.y - 3.0f * (this.p2.y - this.p1.y) - this.p0.y) + 3.0f * (this.p2.y - 2.0f * this.p1.y + this.p0.y)) + 3.0f * (this.p1.y - this.p0.y)) + this.p0.y;
            return new Point(x, y);
        }

        private boolean isLine(float unitsPerEm) {
            float a = this.p3.y - this.p0.y;
            float b = this.p3.x - this.p0.x;
            if (Math.abs(a) <= 1.0f && Math.abs(b) <= 1.0f) {
                return true;
            }
            float s = a * (this.p1.x - this.p0.x) + b * (this.p0.y - this.p1.y);
            float t = a * (this.p2.x - this.p0.x) + b * (this.p0.y - this.p2.y);
            float tol = NonOverlappingOutlineConsumer.milliem(unitsPerEm, 1.0f);
            return s * s + t * t < tol * tol * (a * a + b * b);
        }

        private Line makeLine() {
            Line l = new Line(this.p0.x, this.p0.y, this.p3.x, this.p3.y);
            l.id = this.id;
            l.t0 = this.t0;
            l.t1 = this.t1;
            l.origSeg = this.origSeg;
            return l;
        }

        private List splitAtT(float t) {
            ArrayList<Curve> curveList = new ArrayList<Curve>(2);
            float ap0x = this.p0.x;
            float ap0y = this.p0.y;
            float ap1x = t * (this.p1.x - this.p0.x) + ap0x;
            float ap1y = t * (this.p1.y - this.p0.y) + ap0y;
            float ap2x = t * t * (this.p2.x - 2.0f * this.p1.x + this.p0.x) + 2.0f * ap1x - ap0x;
            float ap2y = t * t * (this.p2.y - 2.0f * this.p1.y + this.p0.y) + 2.0f * ap1y - ap0y;
            float ap3x = t * t * t * (this.p3.x - 3.0f * (this.p2.x - this.p1.x) - this.p0.x) + 3.0f * (ap2x - ap1x) + ap0x;
            float ap3y = t * t * t * (this.p3.y - 3.0f * (this.p2.y - this.p1.y) - this.p0.y) + 3.0f * (ap2y - ap1y) + ap0y;
            Curve a = new Curve(ap0x, ap0y, ap1x, ap1y, ap2x, ap2y, ap3x, ap3y);
            a.t0 = 0.0f;
            a.t1 = t;
            a.origSeg = this.origSeg;
            curveList.add(a);
            t = 1.0f - t;
            float bp3x = this.p3.x;
            float bp3y = this.p3.y;
            float bp2x = t * (this.p2.x - this.p3.x) + bp3x;
            float bp2y = t * (this.p2.y - this.p3.y) + bp3y;
            float bp1x = t * t * (this.p1.x - 2.0f * this.p2.x + this.p3.x) + 2.0f * bp2x - bp3x;
            float bp1y = t * t * (this.p1.y - 2.0f * this.p2.y + this.p3.y) + 2.0f * bp2y - bp3y;
            float bp0x = ap3x;
            float bp0y = ap3y;
            Curve b = new Curve(bp0x, bp0y, bp1x, bp1y, bp2x, bp2y, bp3x, bp3y);
            b.t0 = t;
            b.t1 = 1.0f;
            b.origSeg = this.origSeg;
            curveList.add(b);
            return curveList;
        }

        private List splitMid() {
            Point s = new Point();
            Point t = new Point();
            Point u = new Point();
            Point c = new Point();
            ArrayList<Curve> curveList = new ArrayList<Curve>(2);
            s.x = (this.p2.x + this.p3.x) / 2.0f;
            s.y = (this.p2.y + this.p3.y) / 2.0f;
            t.x = (this.p1.x + this.p2.x) / 2.0f;
            t.y = (this.p1.y + this.p2.y) / 2.0f;
            u.x = (this.p0.x + this.p1.x) / 2.0f;
            u.y = (this.p0.y + this.p1.y) / 2.0f;
            c.x = (s.x + 2.0f * t.x + u.x) / 4.0f;
            c.y = (s.y + 2.0f * t.y + u.y) / 4.0f;
            float ct = (this.t0 + this.t1) / 2.0f;
            Curve curve = new Curve(this.p0.x, this.p0.y, u.x, u.y, (t.x + u.x) / 2.0f, (t.y + u.y) / 2.0f, c.x, c.y);
            curve.t0 = this.t0;
            curve.t1 = ct;
            curve.depth = this.depth + 1L;
            curve.origSeg = this.origSeg;
            curveList.add(curve);
            curve = new Curve(c.x, c.y, (s.x + t.x) / 2.0f, (s.y + t.y) / 2.0f, s.x, s.y, this.p3.x, this.p3.y);
            curve.t0 = ct;
            curve.t1 = this.t1;
            curve.depth = this.depth;
            curve.origSeg = this.origSeg;
            curveList.add(curve);
            return curveList;
        }

        private boolean isFlatEnough(float unitsPerEm) {
            if (this.depth == 6L) {
                return true;
            }
            if (Math.abs(this.bounds.right - this.bounds.left) > NonOverlappingOutlineConsumer.milliem(unitsPerEm, 127.0f) || Math.abs(this.bounds.top - this.bounds.bottom) > NonOverlappingOutlineConsumer.milliem(unitsPerEm, 127.0f)) {
                this.depth = 0L;
                return false;
            }
            if ((this.p0.x > this.p1.x || this.p1.x > this.p2.x || this.p2.x > this.p3.x) && (this.p3.x > this.p2.x || this.p2.x > this.p1.x || this.p1.x > this.p0.x) || (this.p0.y > this.p1.y || this.p1.y > this.p2.y || this.p2.y > this.p3.y) && (this.p3.y > this.p2.y || this.p2.y > this.p1.y || this.p1.y > this.p0.y)) {
                return false;
            }
            float eps3 = NonOverlappingOutlineConsumer.milliem(unitsPerEm, 9.0f);
            float c1x = Math.abs(this.p1.x - this.p0.x);
            float c3x = Math.abs(this.p3.x - this.p0.x);
            if (Math.abs(c3x - 3.0f * c1x) > eps3) {
                return false;
            }
            float c2x = Math.abs(this.p2.x - this.p0.x);
            if (Math.abs(2.0f * (c3x - c2x) - c2x) > eps3) {
                return false;
            }
            float c1y = Math.abs(this.p1.y - this.p0.y);
            float c3y = Math.abs(this.p3.y - this.p0.y);
            if (Math.abs(c3y - 3.0f * c1y) > eps3) {
                return false;
            }
            float c2y = Math.abs(this.p2.y - this.p0.y);
            return !(Math.abs(2.0f * (c3y - c2y) - c2y) > eps3);
        }

        private List findExtrema(float a0, float a1, float a2, float a3) {
            float[] t = new float[2];
            int i = 0;
            int j = 0;
            float a = a3 - 3.0f * (a2 - a1) - a0;
            float b = a2 - 2.0f * a1 + a0;
            float c = a1 - a0;
            if (a == 0.0f) {
                if (b != 0.0f) {
                    t[i++] = -c / (2.0f * b);
                }
            } else {
                float r = b * b - a * c;
                if (r >= 0.0f) {
                    r = (float)Math.sqrt(r);
                    t[i++] = (-b + r) / a;
                    t[i++] = (-b - r) / a;
                }
            }
            float[] solns = new float[2];
            --i;
            while (i >= 0) {
                if (0.0f < t[i] && t[i] < 1.0f) {
                    solns[j++] = t[i];
                }
                --i;
            }
            if (j == 2 && solns[0] > solns[1]) {
                solns[0] = t[1];
                solns[1] = t[0];
            }
            ArrayList<Float> solnsList = new ArrayList<Float>();
            for (i = 0; i < j; ++i) {
                Float d = new Float(solns[i]);
                solnsList.add(d);
            }
            return solnsList;
        }

        private float solveAtValue(float value, float a3, float a2, float a1, float a0) {
            float t;
            float delta;
            float a = a3 - 3.0f * (a2 - a1) - a0;
            float b = 3.0f * (a2 - 2.0f * a1 + a0);
            float c = 3.0f * (a1 - a0);
            float lo = 0.0f;
            float hi = 1.0f;
            while (!((double)Math.abs(delta = (t = (lo + hi) / 2.0f) * (t * (t * a + b) + c) + a0 - value) < 0.01)) {
                if (delta < 0.0f) {
                    lo = t;
                    continue;
                }
                hi = t;
            }
            return t;
        }

        @Override
        List solveAtY(float y) {
            List tList = this.findExtrema(this.p3.y, this.p2.y, this.p1.y, this.p0.y);
            int cnt = tList.size();
            Curve[] curves = new Curve[cnt + 1];
            if (cnt > 0) {
                Float t0 = (Float)tList.get(0);
                List T0CurveList = this.splitAtT(t0.floatValue());
                curves[0] = (Curve)T0CurveList.get(0);
                curves[1] = (Curve)T0CurveList.get(1);
                if (cnt > 1) {
                    Float t1 = (Float)tList.get(1);
                    float t = (t1.floatValue() - t0.floatValue()) / (1.0f - t0.floatValue());
                    List T1CurveList = curves[1].splitAtT(t);
                    curves[1] = (Curve)T1CurveList.get(0);
                    curves[2] = (Curve)T0CurveList.get(1);
                }
            } else {
                curves[0] = new Curve(this.p0, this.p1, this.p2, this.p3);
            }
            ArrayList<ICept> iceptList = new ArrayList<ICept>();
            for (int i = 0; i <= cnt; ++i) {
                float icpnt;
                Point pnt3;
                Point pnt2;
                Point pnt1;
                Point pnt0;
                if (curves[i].p3.y > curves[i].p0.y) {
                    pnt0 = curves[i].p0;
                    pnt1 = curves[i].p1;
                    pnt2 = curves[i].p2;
                    pnt3 = curves[i].p3;
                } else {
                    pnt0 = curves[i].p3;
                    pnt1 = curves[i].p2;
                    pnt2 = curves[i].p1;
                    pnt3 = curves[i].p0;
                }
                int wind = curves[i].getWindingY();
                if (y < pnt0.y || y > pnt3.y) continue;
                if (Math2.epsilonEquals(y, pnt0.y)) {
                    icpnt = pnt0.x;
                } else if (Math2.epsilonEquals(y, pnt3.y)) {
                    icpnt = pnt3.x;
                } else {
                    float t = this.solveAtValue(y, pnt3.y, pnt2.y, pnt1.y, pnt0.y);
                    icpnt = t * (t * (t * (pnt3.x - 3.0f * (pnt2.x - pnt1.x) - pnt0.x) + 3.0f * (pnt2.x - 2.0f * pnt1.x + pnt0.x)) + 3.0f * (pnt1.x - pnt0.x)) + pnt0.x;
                }
                ICept ic = new ICept(icpnt, wind);
                iceptList.add(ic);
            }
            return iceptList;
        }

        @Override
        List solveAtX(float x) {
            List tList = this.findExtrema(this.p3.x, this.p2.x, this.p1.x, this.p0.x);
            int cnt = tList.size();
            Curve[] curves = new Curve[cnt + 1];
            if (cnt > 0) {
                Float t0 = (Float)tList.get(0);
                List T0CurveList = this.splitAtT(t0.floatValue());
                curves[0] = (Curve)T0CurveList.get(0);
                curves[1] = (Curve)T0CurveList.get(1);
                if (cnt > 1) {
                    Float t1 = (Float)tList.get(1);
                    float t = (t1.floatValue() - t0.floatValue()) / (1.0f - t0.floatValue());
                    List T1CurveList = curves[1].splitAtT(t);
                    curves[1] = (Curve)T1CurveList.get(0);
                    curves[2] = (Curve)T0CurveList.get(1);
                }
            } else {
                curves[0] = new Curve(this.p0, this.p1, this.p2, this.p3);
            }
            ArrayList<ICept> iceptList = new ArrayList<ICept>();
            for (int i = 0; i <= cnt; ++i) {
                float icpnt;
                Point pnt3;
                Point pnt2;
                Point pnt1;
                Point pnt0;
                if (curves[i].p3.x > curves[i].p0.x) {
                    pnt0 = curves[i].p0;
                    pnt1 = curves[i].p1;
                    pnt2 = curves[i].p2;
                    pnt3 = curves[i].p3;
                } else {
                    pnt0 = curves[i].p3;
                    pnt1 = curves[i].p2;
                    pnt2 = curves[i].p1;
                    pnt3 = curves[i].p0;
                }
                int wind = curves[i].getWindingX();
                if (x < pnt0.x || x > pnt3.x) continue;
                if (Math2.epsilonEquals(x, pnt0.x)) {
                    icpnt = pnt0.y;
                } else if (Math2.epsilonEquals(x, pnt3.x)) {
                    icpnt = pnt3.y;
                } else {
                    float t = this.solveAtValue(x, pnt3.x, pnt2.x, pnt1.x, pnt0.x);
                    icpnt = t * (t * (t * (pnt3.y - 3.0f * (pnt2.y - pnt1.y) - pnt0.y) + 3.0f * (pnt2.y - 2.0f * pnt1.y + pnt0.y)) + 3.0f * (pnt1.y - pnt0.y)) + pnt0.y;
                }
                ICept ic = new ICept(icpnt, wind);
                iceptList.add(ic);
            }
            return iceptList;
        }

        @Override
        int getWindingX() {
            return Curve.getWinding(this.p0.x, this.p3.x);
        }

        @Override
        int getWindingY() {
            return Curve.getWinding(this.p0.y, this.p3.y);
        }

        private static class Limit {
            float min;
            float max;

            Limit(float minimum, float maximum) {
                this.min = minimum;
                this.max = maximum;
            }
        }
    }

    private static class Line
    extends Segment {
        Point p0;
        Point p1;
        float t0;
        float t1;
        Rect bounds;
        int id;

        Line(float x0, float y0, float x1, float y1) {
            this.p0 = new Point(x0, y0);
            this.p1 = new Point(x1, y1);
            this.t0 = 0.0f;
            this.t1 = 1.0f;
            this.setBounds();
        }

        Line(Point start, Point end) {
            this.p0 = new Point(start);
            this.p1 = new Point(end);
            this.t0 = 0.0f;
            this.t1 = 1.0f;
            this.setBounds();
        }

        @Override
        public String toString() {
            String flagStr = (this.flags & 1) != 0 ? "Delete," : "";
            flagStr = (this.flags & 4) != 0 ? flagStr + " WindTested" : flagStr;
            String s = "Point p0:" + this.p0.toString() + " Point p1:" + this.p1.toString() + "t0:" + this.t0 + " t1:" + this.t1 + "flag:" + flagStr + " bounds:" + this.bounds.toString();
            return s;
        }

        @Override
        int getID() {
            return this.id;
        }

        @Override
        Point getFirstPoint() {
            return this.p0;
        }

        @Override
        Point getLastPoint() {
            return this.p1;
        }

        @Override
        boolean horizontal() {
            return Math.abs(this.p1.x - this.p0.x) > Math.abs(this.p1.y - this.p0.y);
        }

        @Override
        void setBounds() {
            float top;
            float bottom;
            float right;
            float left;
            if (this.p0.x < this.p1.x) {
                left = this.p0.x;
                right = this.p1.x;
            } else {
                right = this.p0.x;
                left = this.p1.x;
            }
            if (this.p0.y < this.p1.y) {
                bottom = this.p0.y;
                top = this.p1.y;
            } else {
                top = this.p0.y;
                bottom = this.p1.y;
            }
            this.bounds = new Rect(left, bottom, right, top);
        }

        @Override
        void roundControlPoints(float unitsPerEm) {
            this.p0.x = Math.round(this.p0.x);
            this.p0.y = Math.round(this.p0.y);
            this.p1.x = Math.round(this.p1.x);
            this.p1.y = Math.round(this.p1.y);
        }

        @Override
        Rect getBounds() {
            if (this.bounds != null) {
                return this.bounds;
            }
            this.setBounds();
            return this.bounds;
        }

        @Override
        boolean equalControlPoints(Segment s) {
            if (s instanceof Line) {
                Line l = (Line)s;
                return Math2.epsilonEquals(this.p0.x, l.p0.x) && Math2.epsilonEquals(this.p0.y, l.p0.y) && Math2.epsilonEquals(this.p1.x, l.p1.x) && Math2.epsilonEquals(this.p1.y, l.p1.y);
            }
            return false;
        }

        @Override
        boolean reverseControlPoints(Segment s) {
            if (s instanceof Line) {
                Line l = (Line)s;
                return Math2.epsilonEquals(this.p0.x, l.p1.x) && Math2.epsilonEquals(this.p0.y, l.p1.y) && Math2.epsilonEquals(this.p1.x, l.p0.x) && Math2.epsilonEquals(this.p1.y, l.p0.y);
            }
            return false;
        }

        @Override
        Segment copySegment() {
            Line newl = new Line(this.p0, this.p1);
            newl.t0 = this.t0;
            newl.t1 = this.t1;
            newl.id = this.id;
            newl.flags = this.flags;
            newl.origSeg = this.origSeg;
            return newl;
        }

        private Point computeISectPoint(float t) {
            float x = this.p0.x + t * (this.p1.x - this.p0.x);
            float y = this.p0.y + t * (this.p1.y - this.p0.y);
            return new Point(x, y);
        }

        private boolean iSectRect(Rect r) {
            boolean CLIP_CODE_LEFT = true;
            int CLIP_CODE_RIGHT = 2;
            int CLIP_CODE_BOTTOM = 4;
            int CLIP_CODE_TOP = 8;
            int c0 = this.p0.x < r.left ? 1 : (this.p0.x > r.right ? 2 : 0);
            if (this.p0.y > r.top) {
                c0 |= 8;
            } else if (this.p0.y < r.bottom) {
                c0 |= 4;
            }
            if (c0 == 0) {
                return true;
            }
            int c1 = this.p1.x < r.left ? 1 : (this.p1.x > r.right ? 2 : 0);
            if (this.p1.y > r.top) {
                c1 |= 8;
            } else if (this.p1.y < r.bottom) {
                c1 |= 4;
            }
            if (c1 == 0) {
                return true;
            }
            return (c0 & c1) == 0;
        }

        private List iSectLine(Line l) {
            float a0 = this.p1.y - this.p0.y;
            float b0 = this.p1.x - this.p0.x;
            float a1 = l.p1.y - l.p0.y;
            float b1 = l.p1.x - l.p0.x;
            float d = a1 * b0 - b1 * a0;
            float j = this.p0.y - l.p0.y;
            float k = this.p0.x - l.p0.x;
            float n0 = b1 * j - a1 * k;
            ArrayList<float[]> iSects = new ArrayList<float[]>();
            if (d == 0.0f) {
                if (n0 == 0.0f) {
                    Rect lBounds = l.getBounds();
                    if (!this.bounds.overlap(lBounds)) {
                        return iSects;
                    }
                    Rect r = this.bounds.iSect(lBounds);
                    if (r.left == r.right && r.bottom == r.top) {
                        float[] t = new float[2];
                        if (b0 != 0.0f) {
                            t[0] = Math2.epsilonEquals(this.p1.x, r.left) ? 1.0f : 0.0f;
                            t[1] = Math2.epsilonEquals(l.p1.x, r.left) ? 1.0f : 0.0f;
                        } else {
                            t[0] = Math2.epsilonEquals(this.p1.y, r.bottom) ? 1.0f : 0.0f;
                            t[1] = Math2.epsilonEquals(l.p1.y, r.bottom) ? 1.0f : 0.0f;
                        }
                        iSects.add(t);
                        return iSects;
                    }
                    if (r.right - r.left > r.top - r.bottom) {
                        float[] t = new float[2];
                        float[] t1 = new float[2];
                        t[0] = (r.left - this.p0.x) / b0;
                        t[1] = (r.left - l.p0.x) / b1;
                        t1[0] = (r.right - this.p0.x) / b0;
                        t1[1] = (r.right - l.p0.x) / b1;
                        iSects.add(t);
                        iSects.add(t1);
                        return iSects;
                    }
                    float[] t = new float[2];
                    float[] t1 = new float[2];
                    t[0] = (r.bottom - this.p0.y) / a0;
                    t[1] = (r.bottom - l.p0.y) / a1;
                    t1[0] = (r.top - this.p0.y) / a0;
                    t1[1] = (r.top - l.p0.y) / a1;
                    iSects.add(t);
                    iSects.add(t1);
                    return iSects;
                }
                return iSects;
            }
            float[] t = new float[2];
            t[0] = n0 / d;
            if (t[0] < 0.0f || t[0] > 1.0f) {
                return iSects;
            }
            t[1] = (b0 * j - a0 * k) / d;
            if (t[1] < 0.0f || t[1] > 1.0f) {
                return iSects;
            }
            iSects.add(t);
            return iSects;
        }

        @Override
        List solveAtX(float x) {
            float value = this.p0.y + (x - this.p0.x) * (this.p1.y - this.p0.y) / (this.p1.x - this.p0.x);
            ICept icept = new ICept(value, this.getWindingX());
            ArrayList<ICept> icList = new ArrayList<ICept>();
            icList.add(icept);
            return icList;
        }

        @Override
        List solveAtY(float y) {
            float value = this.p0.x + (y - this.p0.y) * (this.p1.x - this.p0.x) / (this.p1.y - this.p0.y);
            ICept icept = new ICept(value, this.getWindingY());
            ArrayList<ICept> icList = new ArrayList<ICept>();
            icList.add(icept);
            return icList;
        }

        @Override
        int getWindingX() {
            return Line.getWinding(this.p0.x, this.p1.x);
        }

        @Override
        int getWindingY() {
            return Line.getWinding(this.p0.y, this.p1.y);
        }
    }

    private static class ICept {
        float ic;
        int winding;

        ICept(float ic, int winding) {
            this.ic = ic;
            this.winding = winding;
        }
    }

    private static class Rect {
        float left;
        float bottom;
        float right;
        float top;

        Rect(float l, float b, float r, float t) {
            this.left = l;
            this.bottom = b;
            this.right = r;
            this.top = t;
        }

        private void grow(Rect r1) {
            if (this.left > r1.left) {
                this.left = r1.left;
            }
            if (this.bottom > r1.bottom) {
                this.bottom = r1.bottom;
            }
            if (this.right < r1.right) {
                this.right = r1.right;
            }
            if (this.top < r1.top) {
                this.top = r1.top;
            }
        }

        private boolean overlap(Rect r1) {
            boolean doesNotOverlap = this.right < r1.left || this.left > r1.right || this.top < r1.bottom || this.bottom > r1.top;
            return !doesNotOverlap;
        }

        private Rect iSect(Rect r1) {
            float l = Math.max(this.left, r1.left);
            float r = Math.min(this.right, r1.right);
            float t = Math.min(this.top, r1.top);
            float b = Math.max(this.bottom, r1.bottom);
            return new Rect(l, b, r, t);
        }

        public String toString() {
            return "left:" + this.left + " right:" + this.right + "bottom: " + this.bottom + "top: " + this.top;
        }
    }

    private static class Point {
        float x;
        float y;

        Point(float x, float y) {
            this.x = x;
            this.y = y;
        }

        Point() {
        }

        Point(Point p) {
            this.x = p.x;
            this.y = p.y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }

        public boolean equals(Point p) {
            return Math2.epsilonEquals(this.x, p.x) && Math2.epsilonEquals(this.y, p.y);
        }
    }

    private static class ISectException
    extends Exception {
        static final long serialVersionUID = 1L;

        public ISectException() {
        }

        public ISectException(String message) {
            super(message);
        }

        public ISectException(String message, Throwable cause) {
            super(message, cause);
        }

        public ISectException(Throwable cause) {
            super(cause);
        }
    }
}

