/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.F26Dot6Vector;
import com.adobe.fontengine.math.F32Dot0Vector;

public final class TTPoint
implements Cloneable {
    public boolean onCurve;
    public F32Dot0Vector unscaled = new F32Dot0Vector();
    public F26Dot6Vector original;
    public F26Dot6Vector unhinted;
    public F26Dot6Vector hinted;
    public boolean touchedX;
    public boolean touchedY;

    public TTPoint(int x, int y, boolean onCurve) {
        this.unscaled.x = x;
        this.unscaled.y = y;
        this.original = new F26Dot6Vector();
        this.unhinted = new F26Dot6Vector();
        this.hinted = new F26Dot6Vector();
        this.touchedX = false;
        this.touchedY = false;
        this.onCurve = onCurve;
    }

    public void scale(int unitsPerEm, Matrix em2px) {
        double xInEm = (double)this.unscaled.x / (double)unitsPerEm;
        double yInEm = (double)this.unscaled.y / (double)unitsPerEm;
        this.unhinted.x = F26Dot6.fromDouble(em2px.applyToXYGetX(xInEm, yInEm));
        this.unhinted.y = F26Dot6.fromDouble(em2px.applyToXYGetY(xInEm, yInEm));
        this.original.x = this.unhinted.x;
        this.original.y = this.unhinted.y;
        this.hinted.x = this.unhinted.x;
        this.hinted.y = this.unhinted.y;
        this.touchedX = false;
        this.touchedY = false;
    }

    public boolean touched(boolean x) {
        if (x) {
            return this.touchedX;
        }
        return this.touchedY;
    }

    public Object clone() {
        TTPoint p = new TTPoint(this.unscaled.x, this.unscaled.y, this.onCurve);
        p.original.x = this.original.x;
        p.original.y = this.original.y;
        p.hinted.x = this.hinted.x;
        p.hinted.y = this.hinted.y;
        p.unhinted.x = this.unhinted.x;
        p.unhinted.y = this.unhinted.y;
        p.touchedX = this.touchedX;
        p.touchedY = this.touchedY;
        return p;
    }

    public String toString() {
        return "u=" + this.unscaled + " o=" + this.unhinted + " c=" + this.hinted + " on=" + this.onCurve + " t=" + (this.touchedX ? "Y" : "N") + (this.touchedY ? "Y" : "N");
    }
}

