/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.TTInterpreter;
import com.adobe.fontengine.font.opentype.TTOutline;
import com.adobe.fontengine.font.opentype.TTPoint;
import com.adobe.fontengine.math.F26Dot6;

public final class TTSimpleOutline
extends TTOutline {
    public TTPoint[] points;
    public int[] contourEndPoints;
    public OTByteArray instructions;
    public int instructionsOffset;
    public int instructionsLength;
    private boolean isScaled = false;
    private boolean isInstructed = false;
    private int currentUnitsPerEm = -1;
    private Matrix currentEm2px = null;
    private int scanType;

    @Override
    public void scale(int unitsPerEm, Matrix em2px) {
        if (this.isScaled && this.currentUnitsPerEm == unitsPerEm && em2px.equals(this.currentEm2px)) {
            return;
        }
        for (int p = 0; p < this.points.length; ++p) {
            this.points[p].scale(unitsPerEm, em2px);
        }
        int nbOutlinePoints = this.points.length - 4;
        int width = F26Dot6.roundHalfUp(F26Dot6.fromDouble(em2px.applyToXYGetX((double)(this.points[nbOutlinePoints + 1].unscaled.x - this.points[nbOutlinePoints].unscaled.x) / (double)unitsPerEm, 0.0)));
        this.points[nbOutlinePoints + 1].hinted.x = this.points[nbOutlinePoints].hinted.x + width;
        this.points[nbOutlinePoints + 2].hinted.y = F26Dot6.round(this.points[nbOutlinePoints + 2].hinted.y);
        int height = F26Dot6.roundHalfUp(F26Dot6.fromDouble(em2px.applyToXYGetY(0.0, (double)(this.points[nbOutlinePoints + 3].unscaled.y - this.points[nbOutlinePoints + 2].unscaled.y) / (double)unitsPerEm)));
        this.points[nbOutlinePoints + 3].hinted.y = this.points[nbOutlinePoints + 2].hinted.y + height;
        this.isScaled = true;
        this.currentUnitsPerEm = unitsPerEm;
        this.currentEm2px = em2px;
        this.isInstructed = false;
    }

    private void shiftPoints(int dx, int dy, int startingPoint, int numPoints) {
        for (int i = startingPoint; i < numPoints; ++i) {
            this.points[i].hinted.x += dx;
            this.points[i].hinted.y += dy;
        }
    }

    @Override
    public int getScanType() {
        return this.scanType;
    }

    @Override
    public void instruct(TTInterpreter interpreter) throws InvalidGlyphException, UnsupportedFontException {
        if (this.isInstructed) {
            return;
        }
        int roundedPosition = F26Dot6.roundHalfUp(this.points[this.points.length - 4].unhinted.x);
        this.shiftPoints(roundedPosition - this.points[this.points.length - 4].unhinted.x, 0, 0, this.points.length);
        interpreter.runGlyf(this, this.instructions, this.instructionsOffset, this.instructionsOffset + this.instructionsLength);
        this.scanType = interpreter.getScanType();
        this.isInstructed = true;
    }

    @Override
    TTPoint getPoint(int index) throws InvalidGlyphException {
        if (index < 0 || this.points.length <= index) {
            throw new InvalidGlyphException("attempt to access invalid point " + index + " in zone 0");
        }
        return this.points[index];
    }

    @Override
    int getNumOutlinePoints() {
        return this.points.length - 4;
    }

    @Override
    int getNumContours() {
        return this.contourEndPoints.length;
    }

    @Override
    int getContourNextPoint(int contour, int index) throws InvalidGlyphException {
        if (++index > this.contourEndPoints[contour]) {
            index = this.getContourFirstPoint(contour);
        }
        return index;
    }

    @Override
    int getContourFirstPoint(int contour) throws InvalidGlyphException {
        if (contour < 0 || this.contourEndPoints.length <= contour) {
            throw new InvalidGlyphException("attempt to access invalid contour " + contour);
        }
        if (contour == 0) {
            return 0;
        }
        return this.contourEndPoints[contour - 1] + 1;
    }

    @Override
    int getContourLastPoint(int contour) throws InvalidGlyphException {
        if (contour < 0 || this.contourEndPoints.length <= contour) {
            throw new InvalidGlyphException("attempt to access invalid contour " + contour);
        }
        return this.contourEndPoints[contour];
    }

    @Override
    public TTSimpleOutline getMerged() {
        return this;
    }

    @Override
    public void toConsumer(OutlineConsumer c) throws InvalidFontException {
        for (int contour = 0; contour < this.contourEndPoints.length; ++contour) {
            double previousY;
            double previousX;
            TTPoint previousPoint;
            double startY;
            double startX;
            int current = this.getContourFirstPoint(contour);
            int last = this.getContourLastPoint(contour);
            TTPoint currentPoint = this.getPoint(current);
            double currentX = F26Dot6.toDouble(currentPoint.hinted.x);
            double currentY = F26Dot6.toDouble(currentPoint.hinted.y);
            if (currentPoint.onCurve) {
                startX = F26Dot6.toDouble(currentPoint.hinted.x);
                startY = F26Dot6.toDouble(currentPoint.hinted.y);
            } else {
                previousPoint = this.getPoint(last);
                previousX = F26Dot6.toDouble(previousPoint.hinted.x);
                previousY = F26Dot6.toDouble(previousPoint.hinted.y);
                if (previousPoint.onCurve) {
                    startX = previousX;
                    startY = previousY;
                } else {
                    startX = (previousX + currentX) / 2.0;
                    startY = (previousY + currentY) / 2.0;
                }
            }
            c.moveto(startX, startY);
            while (current < last) {
                previousPoint = currentPoint;
                previousX = currentX;
                previousY = currentY;
                currentPoint = this.getPoint(++current);
                currentX = F26Dot6.toDouble(currentPoint.hinted.x);
                currentY = F26Dot6.toDouble(currentPoint.hinted.y);
                if (currentPoint.onCurve) {
                    if (previousPoint.onCurve) {
                        c.lineto(currentX, currentY);
                        continue;
                    }
                    c.curveto(previousX, previousY, currentX, currentY);
                    continue;
                }
                if (previousPoint.onCurve) continue;
                c.curveto(previousX, previousY, (previousX + currentX) / 2.0, (previousY + currentY) / 2.0);
            }
            if (currentPoint.onCurve) {
                if (currentX == startX && currentY == startY) continue;
                c.lineto(startX, startY);
                continue;
            }
            c.curveto(currentX, currentY, startX, startY);
        }
        c.endchar();
    }

    @Override
    public void toConsumer2(OutlineConsumer2 c) throws InvalidFontException {
        c.startOutline();
        for (int contour = 0; contour < this.contourEndPoints.length; ++contour) {
            int startY;
            int startX;
            c.startContour();
            int current = this.getContourFirstPoint(contour);
            int last = this.getContourLastPoint(contour);
            TTPoint currentPoint = this.getPoint(current);
            if (currentPoint.onCurve) {
                startX = currentPoint.hinted.x;
                startY = currentPoint.hinted.y;
            } else {
                TTPoint previousPoint = this.getPoint(last);
                if (previousPoint.onCurve) {
                    startX = previousPoint.hinted.x;
                    startY = previousPoint.hinted.y;
                } else {
                    startX = (previousPoint.hinted.x + currentPoint.hinted.x + 1) / 2;
                    startY = (previousPoint.hinted.y + currentPoint.hinted.y + 1) / 2;
                }
            }
            int currentX = startX;
            int currentY = startY;
            while (current < last) {
                TTPoint previousPoint = currentPoint;
                currentPoint = this.getPoint(++current);
                if (currentPoint.onCurve) {
                    if (previousPoint.onCurve) {
                        c.line(currentX, currentY, currentPoint.hinted.x, currentPoint.hinted.y);
                        currentX = currentPoint.hinted.x;
                        currentY = currentPoint.hinted.y;
                        continue;
                    }
                    c.quadraticCurve(currentX, currentY, previousPoint.hinted.x, previousPoint.hinted.y, currentPoint.hinted.x, currentPoint.hinted.y);
                    currentX = currentPoint.hinted.x;
                    currentY = currentPoint.hinted.y;
                    continue;
                }
                if (previousPoint.onCurve) continue;
                c.quadraticCurve(currentX, currentY, previousPoint.hinted.x, previousPoint.hinted.y, (previousPoint.hinted.x + currentPoint.hinted.x + 1) / 2, (previousPoint.hinted.y + currentPoint.hinted.y + 1) / 2);
                currentX = (previousPoint.hinted.x + currentPoint.hinted.x + 1) / 2;
                currentY = (previousPoint.hinted.y + currentPoint.hinted.y + 1) / 2;
            }
            if (currentPoint.onCurve) {
                if (currentPoint.hinted.x != startX || currentPoint.hinted.y != startY) {
                    c.line(currentX, currentY, startX, startY);
                }
            } else {
                c.quadraticCurve(currentX, currentY, currentPoint.hinted.x, currentPoint.hinted.y, startX, startY);
            }
            c.endContour();
        }
        c.endOutline();
    }

    @Override
    public void translate() {
        int roundedX = F26Dot6.roundHalfUp(this.points[this.points.length - 4].hinted.x);
        int roundedY = F26Dot6.roundHalfUp(this.points[this.points.length - 4].hinted.y);
        this.shiftPoints(-roundedX, -roundedY, 0, this.points.length);
    }
}

