/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import java.io.IOException;

final class PFBInputStream
extends FontInputStream {
    private int bytesLeftInSegment;

    PFBInputStream(FontInputStream stream) {
        super(stream);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int retVal = 0;
        while (len > 0) {
            if (this.bytesLeftInSegment > 0) {
                if (this.bytesLeftInSegment < len) {
                    len = this.bytesLeftInSegment;
                }
                if ((retVal = super.read(b, off, len)) == -1) {
                    throw new IOException("unexpected EOF");
                }
                this.bytesLeftInSegment -= retVal;
                return retVal;
            }
            int escape = super.read();
            int type = super.read();
            if (escape != 128 || type != 1 && type != 2 && type != 3) {
                throw new IOException("invalid segment");
            }
            if (type == 3) {
                if (retVal > 0) {
                    return retVal;
                }
                return -1;
            }
            type = super.read();
            if (type == -1) {
                throw new IOException("unexpected bytes read");
            }
            this.bytesLeftInSegment = type & 0xFF;
            type = super.read();
            if (type == -1) {
                throw new IOException("unexpected bytes read");
            }
            this.bytesLeftInSegment |= (type & 0xFF) << 8;
            type = super.read();
            if (type == -1) {
                throw new IOException("unexpected bytes read");
            }
            this.bytesLeftInSegment |= (type & 0xFF) << 16;
            type = super.read();
            if (type == -1) {
                throw new IOException("unexpected bytes read");
            }
            this.bytesLeftInSegment |= (type & 0xFF) << 24;
        }
        return retVal;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) != 1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public void unread(int b) throws IOException {
        super.unread(b);
        ++this.bytesLeftInSegment;
    }

    @Override
    public void unread(byte[] b, int off, int len) throws IOException {
        if (off != 0) {
            throw new IOException("unsupported unread offset");
        }
        super.unread(b, off, len);
        this.bytesLeftInSegment += len;
    }
}

