/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

final class StreamFont
extends FontImpl {
    static final long serialVersionUID = 1L;
    private final FontInputStream stream;
    private final int length;
    private final boolean wasEmbedded;
    private FontData fontRef;

    StreamFont(FontInputStream stream, int length, boolean wasEmbedded) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.stream = stream;
        this.length = length;
        this.fontRef = this.loadFont(stream, length);
        this.wasEmbedded = wasEmbedded;
    }

    private FontData loadFont(FontInputStream stream, int length) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData[] arr = null;
        try {
            arr = FontLoader.fromStream(stream, length);
        }
        catch (IOException e) {
            throw new FontLoadingException(stream.toString(), e);
        }
        if (arr == null || arr.length == 0) {
            throw new FontLoadingException("Stream did not contain a font.");
        }
        return arr[0];
    }

    @Override
    public boolean wasEmbedded() {
        return this.wasEmbedded;
    }

    @Override
    protected FontData retrieveFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.fontRef;
    }

    @Override
    public int hashCode() {
        return this.stream.hashCode() ^ this.length;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this == obj;
    }

    @Override
    public String toString() {
        return this.stream.toString();
    }

    private void readObject(ObjectInputStream s) throws NotSerializableException {
        throw new NotSerializableException();
    }

    private void writeObject(ObjectOutputStream s) throws NotSerializableException {
        throw new NotSerializableException();
    }

    @Override
    public String getCanonicalPath() {
        return null;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public Object getCachedFontDescription(String key) {
        return null;
    }

    @Override
    public Map<String, Object> getCachedFontDescriptionMap() {
        return null;
    }

    @Override
    public void setCachedFontDescription(String key, Object value) {
    }
}

