/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.ims;

import java.util.Objects;

public final class IMSOrg {
    private final String orgName;
    private final OrgRef orgRef;

    public IMSOrg(String orgName, String ident, String authSrc) {
        this.orgName = orgName;
        this.orgRef = new OrgRef(ident, authSrc);
    }

    public String getOrgName() {
        return this.orgName;
    }

    public OrgRef getOrgRef() {
        return this.orgRef;
    }

    public String toString() {
        return this.orgName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IMSOrg imsOrg = (IMSOrg)o;
        return Objects.equals(this.orgName, imsOrg.orgName) && Objects.equals(this.orgRef, imsOrg.orgRef);
    }

    public int hashCode() {
        return Objects.hash(this.orgName, this.orgRef);
    }

    public static class OrgRef {
        private final String ident;
        private final String authSrc;

        public OrgRef(String ident, String authSrc) {
            this.ident = ident;
            this.authSrc = authSrc;
        }

        public String getIdent() {
            return this.ident;
        }

        public String getAuthSrc() {
            return this.authSrc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrgRef orgRef = (OrgRef)o;
            return Objects.equals(this.ident, orgRef.ident) && Objects.equals(this.authSrc, orgRef.authSrc);
        }

        public int hashCode() {
            return Objects.hash(this.ident, this.authSrc);
        }
    }
}

