/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.taskmanagement;

import java.util.HashMap;

public enum TaskProperty {
    NAME("name"),
    DESCRIPTION("description"),
    INSTRUCTIONS("instructions"),
    OWNER_ID("assignee"),
    TASK_TYPE_NAME("taskTypeName"),
    STATUS("status"),
    CREATED_TIME("startTime"),
    CREATED_BY("createdBy"),
    MODIFIED_TIME("lastModified"),
    MODIFIED_BY("lastModifiedBy"),
    COMPLETED_TIME("endTime"),
    COMPLETED_BY("completedBy"),
    ACTION_NAMES("actionNames"),
    SELECTED_ACTION("selectedAction"),
    PARENT_TASK_ID("parentTaskId"),
    CONTENT_PATH("contentPath"),
    NAME_HIERARCHY("nameHierarchy"),
    DUE_TIME("dueTime"),
    PROGRESS_START_TIME("progressBeginTime"),
    PRIORITY("priority");

    private static HashMap<String, TaskProperty> PROPERTIES_BY_ID;
    private String propertyName;

    private TaskProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public static final boolean isTaskProperty(String propertyName) {
        return PROPERTIES_BY_ID.containsKey(propertyName);
    }

    public static final TaskProperty getTaskProperty(String propertyName) {
        return PROPERTIES_BY_ID.get(propertyName);
    }

    static {
        PROPERTIES_BY_ID = new HashMap(TaskProperty.values().length);
        for (TaskProperty _prop : TaskProperty.values()) {
            PROPERTIES_BY_ID.put(_prop.getPropertyName(), _prop);
        }
    }
}

