/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.api;

public class TranslationException
extends Exception {
    private static final long serialVersionUID = -1281094183029567014L;
    private ErrorCode errorCode = null;
    private String message = null;

    public TranslationException(String message, ErrorCode errorCode) {
        super(message);
        this.message = message;
        this.errorCode = errorCode;
    }

    public TranslationException(String message, Throwable throwable, ErrorCode errorCode) {
        super(message, throwable);
        this.message = message;
        this.errorCode = errorCode;
    }

    @Override
    public String toString() {
        if (this.errorCode != null && this.message != null) {
            return "Error Code: " + (Object)((Object)this.errorCode) + ".  Message: " + this.message;
        }
        if (this.message != null) {
            return this.message;
        }
        return super.toString();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static enum ErrorCode {
        GENERAL_EXCEPTION,
        TRANSLATION_FAILED,
        REQUEST_FAILED,
        NO_ENGINE,
        NOT_SUPPORTED_FORMAT,
        REQUEST_TIMEOUT,
        MISSING_PARAMETER,
        REQUEST_INTERRUPT,
        ENGINE_TEMP_UNAVAILABLE,
        DETECTION_FAILURE,
        TO_FROM_SAME_LANGUAGE,
        UNKNOWN_LANGUAGE,
        SERVICE_NOT_IMPLEMENTED,
        NOT_SUPPORTED_LANG_DIRECTION,
        INVALID_LANGUAGE,
        NO_REGISTERED_FACTORIES,
        UNKNOWN_FACTORY_NAME,
        MISSING_CREDENTIALS,
        UNSUPPORTED_LANGUAGE,
        NOT_AUTHORIZED;

    }
}

