/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.workflow.launcher;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ConfigEntry {
    private String nodetype;
    private List<String> whereClauses;
    private int eventType;
    private String glob;
    private String workflow;
    private String id;
    private String description;
    private boolean enabled;
    private List<String> excludeList;
    private List<String> runModes;
    private List<String> features;
    private List<String> disabledFeatures;

    public ConfigEntry(int eventType, String glob, String nodetype, String whereClause, String workflow, String id, String description, boolean enabled, List<String> excludeList, List<String> runModes) {
        this.eventType = eventType;
        this.glob = glob;
        this.nodetype = nodetype;
        ArrayList<String> conditions = new ArrayList<String>(1);
        conditions.add(whereClause);
        this.whereClauses = conditions;
        this.workflow = workflow;
        this.id = id;
        this.description = description;
        this.enabled = enabled;
        this.excludeList = excludeList;
        this.runModes = runModes;
    }

    public ConfigEntry(int eventType, String glob, String nodetype, List<String> whereClauses, String workflow, String id, String description, boolean enabled, List<String> excludeList, List<String> runModes, List<String> features, List<String> disabledFeatures) {
        this.eventType = eventType;
        this.glob = glob;
        this.nodetype = nodetype;
        this.whereClauses = whereClauses;
        this.workflow = workflow;
        this.id = id;
        this.description = description;
        this.enabled = enabled;
        this.excludeList = excludeList;
        this.runModes = runModes;
        this.features = features;
        this.disabledFeatures = disabledFeatures;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int eventType) {
        this.eventType = eventType;
    }

    public String getGlob() {
        return this.glob;
    }

    public void setGlob(String glob) {
        this.glob = glob;
    }

    public String getNodetype() {
        return this.nodetype;
    }

    public void setNodetype(String nodetype) {
        this.nodetype = nodetype;
    }

    public String getWhereClause() {
        String whereClause = "";
        if (this.whereClauses != null && this.whereClauses.size() > 0) {
            whereClause = this.whereClauses.get(0);
        }
        return whereClause;
    }

    public List<String> getWhereClauses() {
        return this.whereClauses;
    }

    public void setWhereClause(String whereClause) {
        if (this.whereClauses == null) {
            this.whereClauses = new ArrayList<String>(1);
        }
        this.whereClauses.set(0, whereClause);
    }

    public void setWhereClauses(List<String> whereClauses) {
        this.whereClauses = whereClauses;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private String getWhereClauseString() {
        String whereClause = "";
        boolean added = false;
        if (this.whereClauses != null) {
            for (String where : this.whereClauses) {
                if (StringUtils.isBlank(where)) continue;
                if (added) {
                    whereClause = whereClause + " && ";
                }
                whereClause = whereClause + where;
                added = true;
            }
        }
        return whereClause;
    }

    private String getFeaturesString() {
        String featuresString = "";
        boolean added = false;
        if (this.features != null) {
            for (String feature : this.features) {
                if (added) {
                    featuresString = featuresString + " && ";
                }
                featuresString = featuresString + feature;
                added = true;
            }
        }
        return featuresString;
    }

    private String getDisabledFeaturesString() {
        String featuresString = "";
        boolean added = false;
        if (this.disabledFeatures != null) {
            for (String feature : this.disabledFeatures) {
                if (added) {
                    featuresString = featuresString + " && ";
                }
                featuresString = featuresString + "!" + feature;
                added = true;
            }
        }
        return featuresString;
    }

    public int hashCode() {
        String code = String.valueOf(this.eventType) + this.nodetype + this.getWhereClauseString() + this.glob + this.workflow + this.getFeaturesString() + this.getDisabledFeaturesString();
        return code.hashCode();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public void setExcludeList(List<String> excludeList) {
        this.excludeList = excludeList;
    }

    public List<String> getRunModes() {
        return this.runModes;
    }

    public void setRunModes(List<String> runModes) {
        this.runModes = runModes;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public List<String> getDisabledFeatures() {
        return this.disabledFeatures;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public void setDisabledFeatures(List<String> disabledFeatures) {
        this.disabledFeatures = disabledFeatures;
    }

    public String toString() {
        return "ConfigEntry{nodetype='" + this.nodetype + '\'' + ", whereClause='" + this.getWhereClauseString() + '\'' + ", eventType=" + this.eventType + ", glob='" + this.glob + '\'' + ", workflow='" + this.workflow + '\'' + ", id='" + this.id + '\'' + ", description='" + this.description + '\'' + ", enabled=" + this.enabled + ", excludeList'=" + this.excludeList + '\'' + ", runModes='" + this.runModes + '\'' + ", features='" + this.getFeaturesString() + '\'' + ", disabledFeatures='" + this.getDisabledFeaturesString() + '\'' + '}';
    }
}

