/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;

public class BitInputStream {
    private static final int BUFFER_SIZE = 512;
    private InputStream stream = null;
    private int currentBitPos = 0;
    private byte[] buffer = null;
    private int currentBytePos = 0;
    private int maxBytesLimit = 512;

    private void fillBuffer() throws IOException {
        this.maxBytesLimit = this.stream.available() > 0 ? this.stream.read(this.buffer) : -1;
        this.currentBytePos = 0;
    }

    public BitInputStream(InputStream stream) throws IOException {
        this.stream = stream;
    }

    private int readData(int nob) throws IOException {
        if (this.maxBytesLimit == -1) {
            throw new IOException("End of stream has been reached so no data can be read now.");
        }
        if (this.currentBytePos == this.maxBytesLimit) {
            this.fillBuffer();
        }
        int value = (0xFF & this.buffer[this.currentBytePos] << this.currentBitPos) >> 8 - nob;
        this.currentBitPos += nob;
        if (this.currentBitPos >= 8) {
            ++this.currentBytePos;
        }
        this.currentBitPos %= 8;
        return value;
    }

    public int read(int nob) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[512];
            this.fillBuffer();
        }
        int value = 0;
        int bitsToRead = 0;
        while (nob > 0) {
            bitsToRead = nob <= 8 - this.currentBitPos ? nob : 8 - this.currentBitPos;
            value |= this.readData(bitsToRead) << (nob -= bitsToRead);
        }
        return value;
    }

    public int read() throws IOException {
        return this.read(1);
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.buffer = null;
    }

    public long skip(long n) throws IOException {
        this.read((int)n);
        return n;
    }

    public int read(byte[] b, int bitsPerValue, int length) {
        if (b == null || length > b.length) {
            throw new InvalidParameterException("Byte array passed is either null or insufficient to read the number of bytes actually asked to read.");
        }
        if (bitsPerValue > 8) {
            throw new InvalidParameterException("BitsPerValue is " + bitsPerValue + " which is greater than 8 and cann't be fit into byte.");
        }
        int i = 0;
        try {
            for (i = 0; i < length && this.maxBytesLimit != -1; ++i) {
                b[i] = (byte)this.read(bitsPerValue);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return i;
    }

    public int read(int[] b, int bitsPerValue, int length) {
        if (b == null || length > b.length) {
            throw new InvalidParameterException("Byte array passed is either null or insufficient to read the number of bytes actually asked to read.");
        }
        int i = 0;
        try {
            for (i = 0; i < length && this.maxBytesLimit != -1; ++i) {
                b[i] = this.read(bitsPerValue);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return i;
    }

    public int available() throws IOException {
        if (this.maxBytesLimit == -1) {
            return 0;
        }
        return 8 - this.currentBitPos + (this.maxBytesLimit - this.currentBytePos + this.stream.available()) * 8;
    }
}

