/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.stream.InputByteStream;
import java.io.IOException;
import java.io.InputStream;

class InputStreamImpl
extends InputStream {
    InputByteStream ibs;
    protected long mark = 0L;

    public InputStreamImpl(InputByteStream ibs) {
        this.ibs = ibs;
    }

    public int available() throws IOException {
        return (int)(this.ibs.bytesAvailable() <= Integer.MAX_VALUE ? this.ibs.bytesAvailable() : Integer.MAX_VALUE);
    }

    public void mark(int readLimit) {
        try {
            this.mark = this.ibs.getPosition();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        this.ibs.seek(this.mark);
    }

    public long skip(long n) throws IOException {
        n = Math.min(n, this.ibs.length());
        this.ibs.seek(this.ibs.getPosition() + n);
        return n;
    }

    public void close() throws IOException {
        if (this.ibs != null) {
            this.ibs.close();
            this.ibs = null;
        }
    }

    public int read() throws IOException {
        return this.ibs.read();
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        return this.ibs.read(b, offset, length);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

