/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

public final class CosListInt {
    private static final int NUM_LOW_BITS = 5;
    private static final int BLOCK_SIZE = 32;
    private static final int BLOCK_SIZE_MASK = 31;
    private int mMasterBlockSize = 32;
    private int[][] mBlockList = new int[this.mMasterBlockSize][];

    public void add(int index, int value) {
        int[] block;
        int blockIndex = index >> 5;
        if (blockIndex >= this.mMasterBlockSize) {
            int newSize;
            for (newSize = this.mMasterBlockSize; blockIndex >= newSize; newSize *= 2) {
            }
            int[][] newList = new int[newSize][];
            for (int i = 0; i < this.mMasterBlockSize; ++i) {
                newList[i] = this.mBlockList[i];
            }
            this.mMasterBlockSize = newSize;
            this.mBlockList = newList;
        }
        if ((block = this.mBlockList[blockIndex]) == null) {
            block = new int[32];
            this.mBlockList[blockIndex] = block;
        }
        block[index & 0x1F] = value;
    }

    public int get(int index) {
        int blockIndex = index >> 5;
        if (blockIndex >= this.mMasterBlockSize) {
            return 0;
        }
        int[] block = this.mBlockList[blockIndex];
        if (block == null) {
            return 0;
        }
        return block[index & 0x1F];
    }
}

