/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosLinearization;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class CosString
extends CosScalar {
    private byte[] mValue;
    private boolean mIsEncrypted;
    private byte[] mBase;
    private int mBegin;
    private int mLength;
    private boolean mWriteHex;
    private boolean mOddBall;
    private boolean mToEncrypt;
    private CosContainer mParentObj;
    private static final byte[] hexrep = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    private void init(byte[] base, int begin, int length, boolean isEncrypted, boolean writeHex, boolean oddBall, boolean toEncrypt) {
        this.mValue = null;
        this.mBase = base;
        this.mBegin = begin;
        this.mLength = length;
        this.mIsEncrypted = isEncrypted;
        this.mWriteHex = writeHex;
        this.mOddBall = oddBall;
        this.mToEncrypt = toEncrypt;
    }

    CosString(CosDocument doc, byte[] base, int begin, int length, boolean isEncrypted, CosObjectInfo info, boolean writeHex) {
        super(doc, info);
        this.init(base, begin, length, isEncrypted, writeHex, false, true);
    }

    CosString(CosDocument doc, byte[] base, int begin, int length, boolean isEncrypted, CosObjectInfo info, boolean writeHex, boolean oddBall) {
        super(doc, info);
        this.init(base, begin, length, isEncrypted, writeHex, oddBall, true);
    }

    CosString(CosDocument doc, byte[] base, int begin, int length, boolean isEncrypted, CosObjectInfo info) {
        super(doc, info);
        this.init(base, begin, length, isEncrypted, false, false, true);
    }

    CosString copy() throws PDFSecurityException {
        if (this.isIndirect()) {
            return this;
        }
        CosString copy = new CosString(this.getDocument(), this.byteArrayValue(), 0, this.byteArrayValue().length, false, null, this.getWriteHex());
        copy.setToEncrypt(this.getToEncrypt());
        return copy;
    }

    @Override
    public int getType() {
        return 4;
    }

    private void initValue(boolean decrypt) throws PDFSecurityException {
        if (this.mBegin == 0 && this.mLength == this.mBase.length) {
            this.mValue = this.mBase;
        } else {
            this.mValue = new byte[this.mLength];
            System.arraycopy(this.mBase, this.mBegin, this.mValue, 0, this.mLength);
        }
        if (this.mIsEncrypted && decrypt) {
            this.mValue = this.getDocument().getEncryption().decryptString(this, this.mValue);
        }
    }

    void setParentObj(CosContainer parent) {
        this.mParentObj = parent;
    }

    CosContainer getParentObj() {
        return this.mParentObj;
    }

    public byte[] byteArrayValue() throws PDFSecurityException {
        return this.byteArrayValue(true);
    }

    private byte[] byteArrayValue(boolean decrypt) throws PDFSecurityException {
        if (this.mValue == null) {
            this.initValue(decrypt);
        }
        return this.mValue;
    }

    @Override
    public ASString stringValue() throws PDFSecurityException {
        return new ASString(this.byteArrayValue());
    }

    @Override
    public ASHexString hexStringValue() throws PDFSecurityException {
        return new ASHexString(this.byteArrayValue());
    }

    public String asString() throws PDFSecurityException {
        return this.stringValue().asString();
    }

    @Override
    public Object getValue() throws PDFSecurityException {
        return this.byteArrayValue();
    }

    @Override
    public String textValue() throws PDFSecurityException {
        String rslt = "";
        byte[] src = this.byteArrayValue();
        boolean isUnicode = src.length >= 2 && src[0] == -2 && src[1] == -1;
        try {
            rslt = new String(src, isUnicode ? "UTF-16" : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Platform does not support encoding.", e);
        }
        return rslt;
    }

    @Override
    byte[] getObjectEncryptionKey(boolean write) {
        CosLinearization cosLin;
        byte[] key = new byte[5];
        int objNum = this.isIndirect() ? this.getInfo().getObjNum() : this.mParentObj.getInfo().getObjNum();
        int gen = this.isIndirect() ? this.getInfo().getObjGen() : this.mParentObj.getInfo().getObjGen();
        if (!write && (cosLin = this.getDocument().getLinearization()) != null) {
            objNum = cosLin.mapNewToOldObjNum(objNum);
            gen = cosLin.mapNewToOldObjGen(objNum);
        }
        System.arraycopy(ByteOps.splitInt2Bytes(objNum, 3), 0, key, 0, 3);
        System.arraycopy(ByteOps.splitInt2Bytes(gen, 2), 0, key, 3, 2);
        return key;
    }

    @Override
    boolean markNotDirty() {
        if (this.isIndirect()) {
            return super.markNotDirty();
        }
        if (this.mParentObj != null) {
            return this.mParentObj.markNotDirty();
        }
        return false;
    }

    public void setDataInternal(byte[] newData, boolean markDirty) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.mValue = null;
        this.mBase = newData;
        this.mBegin = 0;
        this.mLength = newData.length;
        this.mIsEncrypted = false;
        if (markDirty) {
            try {
                if (this.isIndirect()) {
                    this.getInfo().markDirty();
                } else if (this.mParentObj != null) {
                    this.mParentObj.getInfo().markDirty();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    @Override
    void writeOut(OutputByteStream outStream, boolean inString, boolean inDebug) throws PDFCosParseException, PDFSecurityException, IOException {
        byte[] outValue = this.byteArrayValue(!inDebug);
        if (this.mToEncrypt && !inDebug) {
            outValue = this.getDocument().getEncryption().encryptString(this, outValue);
        }
        if (this.mWriteHex) {
            outStream.write(60);
            for (int i = 0; i < outValue.length; ++i) {
                byte b = outValue[i];
                outStream.write(hexrep[b >> 4 & 0xF]);
                outStream.write(hexrep[b & 0xF]);
            }
            outStream.write(62);
        } else {
            outStream.write(40);
            for (int i = 0; i < outValue.length; ++i) {
                byte b = outValue[i];
                if (b == 10) {
                    outStream.write(92);
                    outStream.write(110);
                    continue;
                }
                if (b == 13) {
                    outStream.write(92);
                    outStream.write(114);
                    continue;
                }
                if (b == 40) {
                    outStream.write(92);
                    outStream.write(40);
                    continue;
                }
                if (b == 41) {
                    outStream.write(92);
                    outStream.write(41);
                    continue;
                }
                if (b == 92) {
                    outStream.write(92);
                    outStream.write(92);
                    continue;
                }
                outStream.write(b);
            }
            outStream.write(41);
        }
        this.mOddBall = false;
    }

    @Override
    public String toString() {
        boolean showEncrypted = true;
        return this.toString(!showEncrypted);
    }

    public ASDate asDate() throws PDFCosParseException, PDFSecurityException {
        try {
            return new ASDate(new ASString(this.byteArrayValue()));
        }
        catch (PDFParseException e) {
            throw new PDFCosParseException(e);
        }
    }

    public void setWriteHex(boolean b) {
        this.mWriteHex = b;
    }

    public boolean getWriteHex() {
        return this.mWriteHex;
    }

    public boolean isOddBall() {
        return this.mOddBall;
    }

    public void setToEncrypt(boolean encrypted) {
        this.mToEncrypt = encrypted;
    }

    public boolean getToEncrypt() {
        return this.mToEncrypt;
    }

    public void setIsEncrypted(boolean encrypted) {
        if (encrypted != this.mIsEncrypted) {
            this.mValue = null;
            this.mIsEncrypted = encrypted;
        }
    }

    public boolean getIsEncrypted() {
        return this.mIsEncrypted;
    }

    public boolean equals(ASString string) {
        return this.equals(string.getBytes());
    }

    public boolean equals(CosString string) {
        try {
            return this.equals(string.byteArrayValue());
        }
        catch (PDFSecurityException e) {
            return false;
        }
    }

    @Override
    public boolean equals(CosObject value) {
        if (!(value instanceof CosString) || value.getDocument() != this.getDocument()) {
            return false;
        }
        if (value == this) {
            return true;
        }
        CosString cosString = (CosString)value;
        return this.equals(cosString);
    }

    public boolean equals(byte[] b) {
        try {
            byte[] myBytes = this.byteArrayValue();
            if (myBytes.length != b.length) {
                return false;
            }
            for (int i = 0; i < myBytes.length; ++i) {
                if (myBytes[i] == b[i]) continue;
                return false;
            }
            return true;
        }
        catch (PDFSecurityException e) {
            return false;
        }
    }
}

