/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASCII85OutputStream
extends FilterOutputStream {
    private int NEWLINE_EVERY = 64;
    private long value;
    private int nShift;
    private int lineLength;
    private long totalOut;

    public ASCII85OutputStream(OutputStream out, FilterParams p) {
        super(out);
        this.initOutput();
        if (p != null && p.containsKey("NewlineEvery")) {
            this.NEWLINE_EVERY = (Integer)p.get("NewlineEvery");
        }
    }

    public ASCII85OutputStream(OutputStream out) {
        this(out, null);
    }

    private void initOutput() {
        this.lineLength = this.NEWLINE_EVERY;
        this.nShift = 24;
        this.value = 0L;
        this.totalOut = 0L;
    }

    private void putEOL() throws IOException {
        this.out.write(13);
        this.out.write(10);
        this.lineLength = 0;
        this.totalOut += 2L;
    }

    private void put1(int ch) throws IOException {
        if (this.lineLength > this.NEWLINE_EVERY - 1) {
            this.putEOL();
        }
        this.out.write((byte)ch);
        ++this.lineLength;
        ++this.totalOut;
    }

    @Override
    public void write(int b) throws IOException {
        this.value += (long)(b & 0xFF) << this.nShift;
        this.nShift -= 8;
        if (this.nShift < 0) {
            if (this.value == 0L) {
                this.put1(122);
            } else {
                int q = (int)(this.value / 7225L);
                int r = (int)(this.value - (long)(7225 * q));
                int d1 = q / 7225;
                int d2 = (q -= 7225 * d1) / 85;
                int d3 = q - 85 * d2;
                int d4 = r / 85;
                int d5 = r - 85 * d4;
                this.put1(d1 + 33);
                this.put1(d2 + 33);
                this.put1(d3 + 33);
                this.put1(d4 + 33);
                this.put1(d5 + 33);
                this.value = 0L;
            }
            this.nShift = 24;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int maxWrite = b.length - off;
        if (maxWrite > len) {
            maxWrite = len;
        }
        while (maxWrite-- > 0) {
            this.write(b[off++] & 0xFF);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        if (this.nShift >= 0 && this.nShift < 24) {
            int q = (int)(this.value / 7225L);
            int r = (int)(this.value - (long)(7225 * q));
            int d1 = q / 7225;
            int d2 = (q -= 7225 * d1) / 85;
            int d3 = q - 85 * d2;
            int d4 = r / 85;
            switch (this.nShift) {
                case 16: {
                    this.put1(d1 + 33);
                    this.put1(d2 + 33);
                    break;
                }
                case 8: {
                    this.put1(d1 + 33);
                    this.put1(d2 + 33);
                    this.put1(d3 + 33);
                    break;
                }
                case 0: {
                    this.put1(d1 + 33);
                    this.put1(d2 + 33);
                    this.put1(d3 + 33);
                    this.put1(d4 + 33);
                }
            }
        }
        if (this.lineLength > this.NEWLINE_EVERY - 2) {
            this.putEOL();
        }
        this.out.write(126);
        this.out.write(62);
        this.totalOut += 2L;
        super.close();
    }

    public long getTotalOut() {
        return this.totalOut;
    }
}

