/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASBoolean;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class FilterParams
extends Hashtable<String, Object> {
    static final long serialVersionUID = 0L;
    public static final String Height_K = "Height";
    public static final String Width_K = "Width";
    public static final String CloseSource_K = "CloseSource";
    public static final String AvoidInOverrun_K = "AvoidInOverrun";
    public static final String Predictor_K = "Predictor";
    public static final String Columns_K = "Columns";
    public static final String Components_K = "Components";
    public static final String BitsPerComponent_K = "BitsPerComponent";
    public static final String EarlyChange_K = "EarlyChange";
    public static final String Rows_K = "Rows";
    public static final String K_K = "K";
    public static final String DamagedRowsBeforeError_K = "DamagedRowsBeforeError";
    public static final String ByteAlign_K = "ByteAlign";
    public static final String DoRTC_K = "DoRTC";
    public static final String DoEOL_K = "DoEOL";
    public static final String BlackIs1_K = "BlackIs1";
    public static final String UncompressedMode_K = "UncompressedMode";
    public static final String ColorSpace_K = "ColorSpace";
    public static final String NewlineEvery_K = "NewlineEvery";
    public static final String JBIG2Globals_K = "JBIG2Globals";
    public static final String CompressionLevel_K = "CompressionLevel";
    public static final String CompressionStrategy_K = "CompressionStrategy";
    public static final String MemoryLevel_K = "MemoryLevel";
    public static final String WindowBits_K = "WindowBits";

    public FilterParams() {
        super(20);
    }

    public ASDictionary toASDictionary() {
        ASDictionary filtDict = new ASDictionary();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            ASNumber num;
            String key = (String)e.nextElement();
            ASName asKey = ASName.create(key);
            Object value = this.get(key);
            if (value instanceof Integer) {
                num = new ASNumber((Integer)value);
                filtDict.put(asKey, num);
                continue;
            }
            if (value instanceof Boolean) {
                ASBoolean bool = new ASBoolean((Boolean)value);
                filtDict.put(asKey, bool);
                continue;
            }
            if (!(value instanceof Double)) continue;
            num = new ASNumber((double)((Double)value));
            filtDict.put(asKey, num);
        }
        return filtDict;
    }

    public CosObject toCosObject(CosDocument doc) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        HashMap<ASName, CosScalar> map = new HashMap<ASName, CosScalar>();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASName asKey = ASName.create(key);
            Object value = this.get(key);
            if (value instanceof Number) {
                Number num = (Number)value;
                CosNumeric cosNum = doc.createCosNumeric(num);
                map.put(asKey, cosNum);
                continue;
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                CosBoolean cosBool = doc.createCosBoolean(bool);
                map.put(asKey, cosBool);
                continue;
            }
            if (!(value instanceof CosObject)) continue;
            map.put(asKey, (CosScalar)value);
        }
        CosDictionary cosDict = doc.createCosDictionary(map, 0);
        return cosDict;
    }
}

