/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import java.io.IOException;

public class ASQuad
extends ASObject {
    private ASCoordinate p1;
    private ASCoordinate p2;
    private ASCoordinate p3;
    private ASCoordinate p4;

    public ASQuad(ASCoordinate p1, ASCoordinate p2, ASCoordinate p3, ASCoordinate p4) {
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.p4 = p4;
    }

    public ASQuad(ASRectangle rect) {
        this.p1 = new ASCoordinate(rect.ll());
        this.p2 = new ASCoordinate(rect.lr());
        this.p3 = new ASCoordinate(rect.ur());
        this.p4 = new ASCoordinate(rect.ul());
    }

    public ASQuad(ASQuad quad) {
        this.p1 = new ASCoordinate(quad.p1);
        this.p2 = new ASCoordinate(quad.p2);
        this.p3 = new ASCoordinate(quad.p3);
        this.p4 = new ASCoordinate(quad.p4);
    }

    public ASCoordinate p1() {
        return this.p1;
    }

    public ASCoordinate p2() {
        return this.p2;
    }

    public ASCoordinate p3() {
        return this.p3;
    }

    public ASCoordinate p4() {
        return this.p4;
    }

    public ASQuad transform(ASMatrix ctm) {
        ASCoordinate new_p1 = this.p1.transform(ctm);
        ASCoordinate new_p2 = this.p2.transform(ctm);
        ASCoordinate new_p3 = this.p3.transform(ctm);
        ASCoordinate new_p4 = this.p4.transform(ctm);
        return new ASQuad(new_p1, new_p2, new_p3, new_p4);
    }

    public String toString() {
        return "[ " + this.p1.toString() + " " + this.p2.toString() + " " + this.p3.toString() + " " + this.p4.toString() + " ]";
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            outputByteStream.write(this.toString().getBytes());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public double getMinX() {
        double[] xValues = new double[]{this.p1.x(), this.p2.x(), this.p3.x(), this.p4.x()};
        double minX = this.p1.x();
        for (int i = 1; i < xValues.length; ++i) {
            if (!(xValues[i] < minX)) continue;
            minX = xValues[i];
        }
        return minX;
    }

    public double getMaxX() {
        double[] xValues = new double[]{this.p1.x(), this.p2.x(), this.p3.x(), this.p4.x()};
        double maxX = this.p1.x();
        for (int i = 1; i < xValues.length; ++i) {
            if (!(xValues[i] > maxX)) continue;
            maxX = xValues[i];
        }
        return maxX;
    }

    public double getMinY() {
        double[] yValues = new double[]{this.p1.y(), this.p2.y(), this.p3.y(), this.p4.y()};
        double minY = this.p1.y();
        for (int i = 1; i < yValues.length; ++i) {
            if (!(yValues[i] < minY)) continue;
            minY = yValues[i];
        }
        return minY;
    }

    public double getMaxY() {
        double[] yValues = new double[]{this.p1.y(), this.p2.y(), this.p3.y(), this.p4.y()};
        double maxY = this.p1.y();
        for (int i = 1; i < yValues.length; ++i) {
            if (!(yValues[i] > maxY)) continue;
            maxY = yValues[i];
        }
        return maxY;
    }
}

